/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.Representation;

public abstract class BooleanOps {
    @Help(key="operator-and")
    @Representation(value="(%s&%s)")
    @Export(value={".and"})
    public static Boolean and(Boolean lhs, Boolean rhs) {
        if (lhs == null) {
            lhs = false;
        }
        if (rhs == null) {
            rhs = false;
        }
        return lhs != false && rhs != false;
    }

    @Help(key="operator-not")
    @Representation(value="(!%s)")
    @Export(value={".not"})
    public static Boolean not(Boolean operand) {
        if (operand == null) {
            operand = false;
        }
        return operand == false;
    }

    @Help(key="operator-or")
    @Representation(value="(%s|%s)")
    @Export(value={".or"})
    public static Boolean or(Boolean lhs, Boolean rhs) {
        if (lhs == null) {
            lhs = false;
        }
        if (rhs == null) {
            rhs = false;
        }
        return lhs != false || rhs != false;
    }

    @Help(key="operator-xor")
    @Representation(value="(%s^%s)")
    @Export(value={".xor"})
    public static Boolean xor(Boolean lhs, Boolean rhs) {
        if (lhs == null) {
            lhs = false;
        }
        if (rhs == null) {
            rhs = false;
        }
        return lhs ^ rhs;
    }
}

