/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.util.Locale;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Cacheable;
import net.intelie.pipes.ConstantPropertySink;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.modules.FallbackToConstant;
import net.intelie.pipes.types.Type;

public class BytesFormatter
implements Cacheable,
ConstantPropertySink {
    private static final long serialVersionUID = 1L;
    private static final String[] NAMES = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
    private final String format0;
    private final String format;
    private final int precision;

    public BytesFormatter(ArgQueue queue) throws PipeException {
        this.precision = ((Double)queue.constantValue((Type)Type.NUMBER).getOptional(new FallbackToConstant<Double>(2.0))).intValue();
        this.format0 = "%,.0f";
        this.format = "%,." + this.precision + "f";
    }

    public String format(Double operand) {
        if (operand == null) {
            return null;
        }
        double value = operand;
        int name = 0;
        while (Math.abs(value) >= 1024.0) {
            value /= 1024.0;
            ++name;
        }
        if (name == 0) {
            return String.format(Locale.US, this.format0, value) + " " + NAMES[name];
        }
        return String.format(Locale.US, this.format, value) + " " + NAMES[name];
    }

    public String toString() {
        return String.valueOf(this.precision);
    }
}

