/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.Representation;
import net.intelie.pipes.TypeParam;
import net.intelie.pipes.util.PipesComparator;

public abstract class ComparableOps {
    @Help(key="operator-lt")
    @Representation(value="(%s<%s)")
    @Export(value={".lt"})
    public static Boolean lt(@TypeParam Comparable lhs, @TypeParam Comparable rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return ComparableOps.compare(lhs, rhs) < 0.0;
    }

    @Help(key="operator-lt-eq")
    @Representation(value="(%s<=%s)")
    @Export(value={".lteq"})
    public static Boolean lteq(@TypeParam Comparable lhs, @TypeParam Comparable rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return ComparableOps.compare(lhs, rhs) <= 0.0;
    }

    @Help(key="operator-gt")
    @Representation(value="(%s>%s)")
    @Export(value={".gt"})
    public static Boolean gt(@TypeParam Comparable lhs, @TypeParam Comparable rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return ComparableOps.compare(lhs, rhs) > 0.0;
    }

    @Help(key="operator-gt-eq")
    @Representation(value="(%s>=%s)")
    @Export(value={".gteq"})
    public static Boolean gteq(@TypeParam Comparable lhs, @TypeParam Comparable rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return ComparableOps.compare(lhs, rhs) >= 0.0;
    }

    @Help(key="scalar-max")
    @Export
    @TypeParam
    public static Comparable max(@TypeParam Comparable lhs, @TypeParam Comparable rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return ComparableOps.compare(lhs, rhs) > 0.0 ? lhs : rhs;
    }

    @Help(key="scalar-min")
    @Export
    @TypeParam
    public static Comparable min(@TypeParam Comparable lhs, @TypeParam Comparable rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return ComparableOps.compare(lhs, rhs) <= 0.0 ? lhs : rhs;
    }

    @Help(key="scalar-max")
    @Export
    @TypeParam
    public static Comparable max(@TypeParam Comparable a, @TypeParam Comparable b, @TypeParam Comparable c, Comparable ... ds) {
        Comparable result = ComparableOps.max(a, ComparableOps.max(b, c));
        for (Comparable d : ds) {
            result = ComparableOps.max(result, d);
        }
        return result;
    }

    @Help(key="scalar-min")
    @Export
    @TypeParam
    public static Comparable min(@TypeParam Comparable a, @TypeParam Comparable b, @TypeParam Comparable c, Comparable ... ds) {
        Comparable result = ComparableOps.min(a, ComparableOps.min(b, c));
        for (Comparable d : ds) {
            result = ComparableOps.min(result, d);
        }
        return result;
    }

    @Help(key="scalar-compare")
    @Export
    public static Double compare(@TypeParam Comparable c1, @TypeParam Comparable c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        return PipesComparator.instance().compare((Object)c1, (Object)c2);
    }
}

