/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Cacheable;
import net.intelie.pipes.ConstantPropertySink;
import net.intelie.pipes.Literal;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.types.Type;

public class DateFormatter
implements Cacheable,
ConstantPropertySink {
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final long serialVersionUID = 1L;
    private final String formatStr;
    private final String zoneStr;
    private final ZoneId zone;
    private transient DateTimeFormatter formatter;

    public DateFormatter(ArgQueue queue) throws PipeException {
        try {
            this.formatStr = (String)queue.constantValue((Type)Type.STRING).getOptional();
            this.zoneStr = (String)queue.constantValue((Type)Type.STRING).getOptional();
            this.zone = this.zoneStr != null ? ZoneId.of(this.zoneStr) : ZoneId.systemDefault();
            this.initFormatter();
        }
        catch (Exception e) {
            throw PipeException.handle((Throwable)e);
        }
    }

    private DateTimeFormatter initFormatter() {
        if (this.formatter == null) {
            this.formatter = DateTimeFormatter.ofPattern(this.formatStr != null ? this.formatStr : DEFAULT_PATTERN, Locale.getDefault(Locale.Category.FORMAT)).withZone(this.zone);
        }
        return this.formatter;
    }

    public String format(Double value) {
        if (value == null) {
            return null;
        }
        return this.initFormatter().format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(value.longValue()), this.zone));
    }

    public Double parse(String value) {
        if (value == null) {
            return null;
        }
        this.initFormatter();
        return ZonedDateTime.parse(value, this.initFormatter()).toInstant().toEpochMilli();
    }

    public String toString() {
        return this.formatStr != null ? Literal.newString((Object)this.formatStr) + (this.zoneStr != null ? ", " + Literal.newString((Object)this.zoneStr) : "") : "";
    }
}

