/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.functions.CronPeriodSpec;
import net.intelie.pipes.functions.DateFormatter;
import net.intelie.pipes.functions.SimplePeriodSpec;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.PeriodUnit;
import net.intelie.pipes.time.SimplePeriod;
import net.intelie.pipes.util.MillisecsHelper;

public abstract class DateOps {
    @Help(key="scalar-dateadd")
    @Export
    public static Double dateadd(Double operand, Period period) {
        if (operand == null) {
            return null;
        }
        return period.add(operand.longValue());
    }

    @Help(key="scalar-datesub")
    @Export
    public static Double datesub(Double operand, Period period) {
        if (operand == null) {
            return null;
        }
        return period.sub(operand.longValue());
    }

    @Help(key="scalar-datefloor")
    @Export
    public static Double datefloor(Double operand, Period period) {
        if (operand == null) {
            return null;
        }
        return period.floor(operand.longValue());
    }

    @Help(key="scalar-dateformat")
    @Export
    public static String dateformat(Double operand, DateFormatter formatter) {
        return formatter.format(operand);
    }

    @Help(key="scalar-dateparse")
    @Export
    public static Double dateparse(String operand, DateFormatter formatter) {
        return formatter.parse(operand);
    }

    @Help(key="scalar-milliseconds")
    @Export
    public static String milliseconds(Double operand) {
        return DateOps.milliseconds(operand, null);
    }

    @Help(key="scalar-milliseconds")
    @Export
    public static String milliseconds(Double operand, Double precision) {
        if (operand == null) {
            return null;
        }
        if (precision == null) {
            precision = 0.0;
        }
        return MillisecsHelper.eval(Math.round(operand * 1000000.0), precision.intValue());
    }

    @Help(key="scalar-period")
    @Export(value={".period", "period"})
    public static Period _period(SimplePeriodSpec spec, Double amount, String unit) {
        return DateOps._period(spec, amount, unit, null);
    }

    @Help(key="scalar-period")
    @Export(value={".period", "period"})
    public static Period _period(SimplePeriodSpec spec, Double amount, String unit, String zone) {
        if (amount == null) {
            return null;
        }
        PeriodUnit unitObj = PeriodUnit.fromNameSafe((String)unit);
        if (unitObj == null) {
            return null;
        }
        return new SimplePeriod(amount.intValue(), unitObj, SimplePeriodSpec.makeZone(zone));
    }

    @Help(key="scalar-cron")
    @Export
    public static Period cron(CronPeriodSpec spec) {
        return spec.make();
    }
}

