/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.util.ArrayList;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Expression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.TypedConstant;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Preconditions;

public class EnumerateSpec
extends TypedConstant {
    private static final long serialVersionUID = 1L;

    public EnumerateSpec(ArgQueue queue) throws PipeException {
        super(EnumerateSpec.resolveType(queue.copy()));
    }

    private static Type resolveType(ArgQueue copy) throws PipeException {
        Expression expr = (Expression)copy.expression((Type)Type.SEQ).get();
        RowType rowType = (RowType)Type.extract((Type)expr.type(), RowType.class);
        if (rowType != null && rowType.fields() != null) {
            return EnumerateSpec.resolveRow(rowType);
        }
        return EnumerateSpec.resolveSeq((Expression<Iterable>)expr);
    }

    private static Type resolveSeq(Expression<Iterable> expr) {
        SeqType seqType = (SeqType)Type.extract((Type)expr.type(), SeqType.class);
        Preconditions.checkNotNull((Object)seqType, (Object)"BUG: must be seq");
        return new SeqType((Type)EnumerateSpec.single(seqType.type()));
    }

    private static Type resolveRow(RowType type) {
        return new RowType(new RowFields(EnumerateSpec.resolveClause(type.fields().timestamp()), EnumerateSpec.resolveClause(type.fields().group()), EnumerateSpec.resolveClause(type.fields().select())));
    }

    private static ClauseInfo resolveClause(ClauseInfo clause) {
        ArrayList<FieldInfo> newFields = new ArrayList<FieldInfo>();
        for (FieldInfo field : clause) {
            newFields.add(new FieldInfo(field.name(), (Type)EnumerateSpec.single(field.type())));
        }
        return new ClauseInfo(newFields);
    }

    private static RowType single(Type valueType) {
        return new RowType(new RowFields(new ClauseInfo(new FieldInfo[]{new FieldInfo("index", (Type)Type.NUMBER), new FieldInfo("value", valueType)})));
    }
}

