/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.ConstantPropertySink;
import net.intelie.pipes.Literal;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Row;
import net.intelie.pipes.TypedCacheable;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.MapType;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

public class IterMapSpec
implements TypedCacheable,
ConstantPropertySink {
    private static final long serialVersionUID = 1L;
    private final Type type;
    private final String keyName;
    private final String valueName;
    private final SeqType seqType;
    private final MapType mapType;
    private final RowFields fields;

    public IterMapSpec(ArgQueue queue, ResolverState state) throws PipeException {
        Type type = state.get("itermap");
        this.seqType = (SeqType)Type.extract((Type)type, SeqType.class);
        this.mapType = (MapType)Type.extract((Type)type, MapType.class);
        this.fields = RowType.getFields((Type)type);
        PipeException.check((Type.OBJECT.equals((Object)type) || this.seqType != null || this.mapType != null ? 1 : 0) != 0, (String)"The expression type must be a seq, map or an object. It is: %s", (Object[])new Object[]{type});
        this.keyName = (String)queue.constantValue((Type)Type.STRING).getOptional();
        this.valueName = (String)queue.constantValue((Type)Type.STRING).getOptional();
        this.type = this.decideType(this.keyName, this.valueName);
    }

    private Type decideType(String keyName, String valueName) {
        if (this.fields != null) {
            return new RowType(new RowFields(this.makeClause(this.fields.timestamp(), keyName, valueName), this.makeClause(this.fields.group(), keyName, valueName), this.makeClause(this.fields.select(), keyName, valueName)));
        }
        if (this.seqType != null) {
            return new SeqType((Type)this.makeRowType(keyName, (Type)Type.NUMBER, valueName, this.seqType.type()));
        }
        if (this.mapType != null) {
            return new SeqType((Type)this.makeRowType(keyName, this.mapType.keyType(), valueName, this.mapType.valueType()));
        }
        return new SeqType((Type)this.makeRowType(keyName, (Type)Type.OBJECT, valueName, (Type)Type.OBJECT));
    }

    private ClauseInfo makeClause(ClauseInfo clause, String keyName, String valueName) {
        ArrayList<FieldInfo> clauseList = new ArrayList<FieldInfo>();
        for (FieldInfo info : clause) {
            clauseList.add(new FieldInfo(info.name(), (Type)this.makeRowType(keyName, (Type)Type.STRING, valueName, info.type())));
        }
        return new ClauseInfo(clauseList);
    }

    private RowType makeRowType(String keyName, Type keyType, String valueName, Type valueType) {
        return new RowType(new RowFields(new ClauseInfo(new FieldInfo[0]), new ClauseInfo(new FieldInfo[]{new FieldInfo(keyName != null ? keyName : "key", keyType)}), new ClauseInfo(new FieldInfo[]{new FieldInfo(valueName != null ? valueName : "value", valueType)})));
    }

    public Type type() {
        return this.type;
    }

    public Iterable eval(Object obj) {
        if (this.fields != null && obj instanceof Row) {
            Row row = (Row)obj;
            int size = this.fields.size();
            Object[] answer = new Row[size];
            for (int i = 0; i < size; ++i) {
                answer[i] = new ArrayRow(new Object[]{this.fields.name(i), row.get(i)});
            }
            return new ArrayRow(answer);
        }
        if (this.seqType != null && obj instanceof Iterable) {
            return new IterableIterable((Iterable)obj);
        }
        if (obj instanceof Map) {
            return new MapIterable((Map)obj);
        }
        return null;
    }

    public String toString() {
        return this.keyName != null ? Literal.newString((Object)this.keyName) + (this.valueName != null ? ", " + Literal.newString((Object)this.valueName) : "") : "";
    }

    private static class IterableIterable
    implements Iterable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Iterable iterable;

        public IterableIterable(Iterable iterable) {
            this.iterable = iterable;
        }

        public Iterator iterator() {
            return new IterableIterator();
        }

        private class IterableIterator
        implements Iterator,
        Serializable {
            private static final long serialVersionUID = 1L;
            private final Iterator<?> it;
            private double current;

            private IterableIterator() {
                this.it = IterableIterable.this.iterable.iterator();
                this.current = 0.0;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            public Object next() {
                Object[] objectArray = new Object[2];
                double d = this.current;
                this.current = d + 1.0;
                objectArray[0] = d;
                objectArray[1] = this.it.next();
                return new ArrayRow(objectArray);
            }
        }
    }

    private static class MapIterable
    implements Iterable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<?, ?> obj;

        public MapIterable(Map<?, ?> obj) {
            this.obj = obj;
        }

        public Iterator iterator() {
            return new MapIterator();
        }

        private class MapIterator
        implements Iterator,
        Serializable {
            private static final long serialVersionUID = 1L;
            private final Iterator<? extends Map.Entry<?, ?>> it;

            private MapIterator() {
                this.it = MapIterable.this.obj.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            public Object next() {
                Map.Entry<?, ?> entry = this.it.next();
                return new ArrayRow(new Object[]{entry.getKey(), entry.getValue()});
            }
        }
    }
}

