/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.util.ArrayList;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.TypedCacheable;
import net.intelie.pipes.modules.FallbackToUnderscore;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.LiteralRepresentation;
import net.intelie.pipes.util.Preconditions;

public class MapNamesSpec
implements TypedCacheable<Row> {
    private static final long serialVersionUID = 1L;
    private final RowType type;
    private final Row value;

    public MapNamesSpec(ArgQueue queue) throws PipeException {
        Scalar seq = (Scalar)queue.constant((Type)Type.SEQ).get();
        Type innerType = this.extractInnerType((Scalar<Iterable>)seq);
        Iterable it = (Iterable)seq.eval(null, null);
        CompilerContext newContext = queue.context().newSource(queue.metadata().withType(innerType));
        Scalar expr = (Scalar)queue.withContext(newContext).scalar((Type)Type.STRING).getOptional(new FallbackToUnderscore(Type.STRING));
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        ArrayList values = new ArrayList();
        for (Object obj : it) {
            if (values.size() >= 128) {
                throw new PipeException((Object)"Too many iterable items. Stopped counting at 128.");
            }
            String name = (String)expr.eval(null, obj);
            if (name == null) {
                throw new PipeException("Unexpected null value when evaluating: %s.", new Object[]{LiteralRepresentation.toString((Type)innerType, obj)});
            }
            fields.add(new FieldInfo(name, innerType));
            values.add(obj);
        }
        this.type = new RowType(new RowFields(new ClauseInfo(fields)));
        this.value = new ArrayRow(values.toArray());
    }

    public Row value() {
        return this.value;
    }

    private Type extractInnerType(Scalar<Iterable> seq) {
        SeqType seqType = (SeqType)Type.extract((Type)seq.type(), SeqType.class);
        Preconditions.checkNotNull((Object)seqType, (String)"Must be a seq: %s", (Object[])new Object[]{seq.type()});
        return seqType.type();
    }

    public Type<Row> type() {
        return this.type;
    }
}

