/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.regex.Pattern;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Cacheable;
import net.intelie.pipes.ConstantPropertySink;
import net.intelie.pipes.Literal;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.types.Type;

public class NumberFormatter
implements Cacheable,
ConstantPropertySink {
    private static final long serialVersionUID = 1L;
    private static final Pattern REMOVE_NON_LETTERS = Pattern.compile("[^\\w]");
    private final DecimalFormat formatter;
    private final String repr;

    public NumberFormatter(ArgQueue queue) throws PipeException {
        String format = (String)queue.constantValue((Type)Type.STRING).getOptional();
        String locale = (String)queue.constantValue((Type)Type.STRING).getOptional();
        this.repr = this.decideRepr(format, locale);
        this.formatter = NumberFormatter.safeFormat(format, locale);
    }

    private static DecimalFormat safeFormat(String format, String locale) throws PipeException {
        if (locale == null && format == null) {
            return null;
        }
        try {
            if (format == null) {
                format = "0.######";
            }
            DecimalFormatSymbols symbols = NumberFormatter.makeLocale(locale);
            return new DecimalFormat(format, symbols);
        }
        catch (Exception e) {
            throw PipeException.handle((Throwable)e);
        }
    }

    private static DecimalFormatSymbols makeLocale(String locale) {
        if (locale == null) {
            return new DecimalFormatSymbols(Locale.US);
        }
        String language = "";
        String country = "";
        String variant = "";
        if ((locale = REMOVE_NON_LETTERS.matcher(locale).replaceAll("")).length() >= 2) {
            language = locale.substring(0, 2);
        }
        if (locale.length() >= 4) {
            country = locale.substring(2, 4);
            variant = locale.substring(4);
        }
        if (NumberFormatter.isInvalid(new Locale(language, country, variant))) {
            throw new IllegalArgumentException("Invalid locale: " + locale);
        }
        return new DecimalFormatSymbols(new Locale(language, country, variant));
    }

    private static boolean isInvalid(Locale locale) {
        try {
            return locale.getISO3Language() == null || locale.getISO3Country() == null;
        }
        catch (MissingResourceException e) {
            return true;
        }
    }

    private String decideRepr(String format, String locale) {
        return Literal.newString((Object)format) + (locale != null ? ", " + Literal.newString((Object)locale) : "");
    }

    public synchronized String format(Double value) {
        if (value == null) {
            return null;
        }
        if (this.formatter == null) {
            return Type.STRING.cast((Object)value);
        }
        return this.formatter.format(value);
    }

    public synchronized Double parse(String value) throws ParseException {
        if (value == null) {
            return null;
        }
        if (this.formatter == null) {
            return Type.NUMBER.cast((Object)value);
        }
        return this.formatter.parse(value).doubleValue();
    }

    public String toString() {
        return this.repr;
    }
}

