/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.text.ParseException;
import java.util.concurrent.ThreadLocalRandom;
import net.intelie.pipes.DoNotOptimize;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.Representation;
import net.intelie.pipes.functions.BytesFormatter;
import net.intelie.pipes.functions.NumberFormatter;
import net.intelie.pipes.util.DisplayNumberHelper;

public abstract class NumberOps {
    public static final double SQRT_2_PI = Math.sqrt(Math.PI * 2);
    public static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();

    @Help(key="scalar-abs")
    @Export
    public static Double abs(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.abs(operand);
    }

    @Help(key="operator-add-number")
    @Representation(value="(%s+%s)")
    @Export(value={".add", "add"})
    public static Double add(Double lhs, Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return lhs + rhs;
    }

    @Help(key="operator-sub")
    @Representation(value="(%s-%s)")
    @Export(value={".sub", "sub"})
    public static Double sub(Double lhs, Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return lhs - rhs;
    }

    @Help(key="operator-mul")
    @Representation(value="(%s*%s)")
    @Export(value={".mul", "mul"})
    public static Double mul(Double lhs, Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return lhs * rhs;
    }

    @Help(key="operator-div")
    @Representation(value="(%s/%s)")
    @Export(value={".div", "div"})
    public static Double div(Double lhs, Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (rhs == 0.0) {
            return 0.0;
        }
        return lhs / rhs;
    }

    @Help(key="operator-intdiv")
    @Representation(value="(%s//%s)")
    @Export(value={".intdiv", "intdiv"})
    public static Double intdiv(Double lhs, Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (rhs == 0.0) {
            return 0.0;
        }
        return Math.floor(lhs / rhs);
    }

    @Help(key="operator-neg")
    @Representation(value="(-%s)")
    @Export(value={".neg", "neg"})
    public static Double neg(Double operand) {
        if (operand == null) {
            return null;
        }
        if (operand == 0.0) {
            return 0.0;
        }
        return -operand.doubleValue();
    }

    @Help(key="scalar-log")
    @Export
    public static Double log(Double value) {
        if (value == null) {
            return null;
        }
        return Math.log(value);
    }

    @Help(key="scalar-exp")
    @Export
    public static Double exp(Double value) {
        if (value == null) {
            return null;
        }
        return Math.exp(value);
    }

    @Help(key="scalar-log")
    @Export
    public static Double log(Double value, Double base) {
        if (value == null || base == null) {
            return null;
        }
        return Math.log(value) / Math.log(base);
    }

    @Help(key="scalar-pow")
    @Representation(value="(%s**%s)")
    @Export(value={".pow", "pow"})
    public static Double pow(Double lhs, Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return Math.pow(lhs, rhs);
    }

    @Help(key="scalar-pi")
    @Export
    public static Double pi() {
        return Math.PI;
    }

    @Help(key="operator-mod")
    @Representation(value="(%s%%%s)")
    @Export(value={".mod", "mod"})
    public static Double remainder(Double lhs, Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (rhs == 0.0) {
            return 0.0;
        }
        return lhs % rhs;
    }

    @Help(key="scalar-bytes")
    @Export
    public static String bytes(Double operand, BytesFormatter formatter) {
        return formatter.format(operand);
    }

    @Help(key="scalar-format")
    @Export
    public static String format(Double operand, NumberFormatter formatter) {
        return formatter.format(operand);
    }

    @Help(key="scalar-displaynumber")
    @Export(value={"displaynumber"})
    public static String displayNumber(Double operand) {
        if (operand == null) {
            return null;
        }
        return DisplayNumberHelper.eval(operand);
    }

    @Help(key="scalar-parse")
    @Export
    public static Double parse(String operand, NumberFormatter formatter) throws ParseException {
        return formatter.parse(operand);
    }

    @Help(key="scalar-round")
    @Export
    public static Double round(Double operand) {
        return NumberOps.round(operand, null);
    }

    @Help(key="scalar-round")
    @Export
    public static Double round(Double operand, Double precision) {
        if (operand == null) {
            return null;
        }
        if (precision == null) {
            precision = 0.0;
        }
        double factor = Math.pow(10.0, precision);
        return (double)Math.round(operand * factor) / factor;
    }

    @Help(key="scalar-ceil")
    @Export
    public static Double ceil(Double operand) {
        return NumberOps.ceil(operand, null);
    }

    @Help(key="scalar-ceil")
    @Export
    public static Double ceil(Double operand, Double precision) {
        if (operand == null) {
            return null;
        }
        if (precision == null) {
            precision = 0.0;
        }
        double factor = Math.pow(10.0, precision);
        return Math.ceil(operand * factor) / factor;
    }

    @Help(key="scalar-floor")
    @Export
    public static Double floor(Double operand) {
        return NumberOps.floor(operand, null);
    }

    @Help(key="scalar-floor")
    @Export
    public static Double floor(Double operand, Double precision) {
        if (operand == null) {
            return null;
        }
        if (precision == null) {
            precision = 0.0;
        }
        double factor = Math.pow(10.0, precision);
        return Math.floor(operand * factor) / factor;
    }

    @Help(key="scalar-sin")
    @Export
    public static Double sin(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.sin(operand);
    }

    @Help(key="scalar-cos")
    @Export
    public static Double cos(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.cos(operand);
    }

    @Help(key="scalar-tan")
    @Export
    public static Double tan(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.tan(operand);
    }

    @Help(key="scalar-asin")
    @Export
    public static Double asin(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.asin(operand);
    }

    @Help(key="scalar-acos")
    @Export
    public static Double acos(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.acos(operand);
    }

    @Help(key="scalar-atan")
    @Export
    public static Double atan(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.atan(operand);
    }

    @Help(key="scalar-sinh")
    @Export
    public static Double sinh(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.sinh(operand);
    }

    @Help(key="scalar-cosh")
    @Export
    public static Double cosh(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.cosh(operand);
    }

    @Help(key="scalar-tanh")
    @Export
    public static Double tanh(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.tanh(operand);
    }

    @Help(key="scalar-atan2")
    @Export
    public static Double atan2(Double y, Double x) {
        if (x == null || y == null) {
            return null;
        }
        return Math.atan2(y, x);
    }

    @Help(key="scalar-normdist")
    @Export
    public static Double normdist(Double x, Double mean, Double stdev, Boolean accumulate) {
        if (x == null || mean == null || stdev == null) {
            return null;
        }
        x = (x - mean) / stdev;
        if (Boolean.TRUE.equals(accumulate)) {
            double sum = x;
            double value = x;
            for (int i = 1; i < 64; ++i) {
                value = value * x * x / (double)(2 * i + 1);
                sum += value;
            }
            return 0.5 + sum / SQRT_2_PI * Math.exp(-(x * x) / 2.0);
        }
        return Math.exp(-0.5 * x * x) / (stdev * SQRT_2_PI);
    }

    @Help(key="scalar-normdist")
    @Export
    public static Double normdist(Double x, Double mean, Double stdev) {
        return NumberOps.normdist(x, mean, stdev, true);
    }

    @Help(key="scalar-random")
    @Export
    @DoNotOptimize
    public static Double random() {
        return RANDOM.nextDouble();
    }

    @Help(key="scalar-random")
    @Export
    @DoNotOptimize
    public static Double random(Double to) {
        return RANDOM.nextDouble() * to;
    }

    @Help(key="scalar-random")
    @Export
    @DoNotOptimize
    public static Double random(Double from, Double to) {
        return from + RANDOM.nextDouble() * (to - from);
    }

    @Help(key="scalar-normrandom")
    @Export
    @DoNotOptimize
    public static Double normrandom() {
        return RANDOM.nextGaussian();
    }

    @Help(key="scalar-normrandom")
    @Export
    @DoNotOptimize
    public static Double normrandom(Double mean) {
        if (mean == null) {
            return null;
        }
        return RANDOM.nextGaussian() + mean;
    }

    @Help(key="scalar-normrandom")
    @Export
    @DoNotOptimize
    public static Double normrandom(Double mean, Double stdev) {
        if (stdev == null) {
            return null;
        }
        if (mean == null) {
            return null;
        }
        return RANDOM.nextGaussian() * stdev + mean;
    }

    @Help(key="scalar-aequal")
    @Export
    public static Boolean aequal(Double lhs, Double rhs, Double epsilon) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (epsilon == null) {
            epsilon = 1.0E-6;
        }
        return Math.abs(lhs - rhs) < epsilon;
    }

    @Help(key="scalar-aequal")
    @Export
    public static Boolean aequal(Double lhs, Double rhs) {
        return NumberOps.aequal(lhs, rhs, null);
    }

    @Help(key="scalar-sqrt")
    @Export
    public static Double sqrt(Double operand) {
        if (operand == null) {
            return null;
        }
        return Math.sqrt(operand);
    }
}

