/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.Inject;
import net.intelie.pipes.Representation;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scope;
import net.intelie.pipes.TypeParam;
import net.intelie.pipes.WithType;
import net.intelie.pipes.functions.MapNamesSpec;
import net.intelie.pipes.functions.MetadataSpec;
import net.intelie.pipes.functions.ObjectGetSpec;
import net.intelie.pipes.functions.PeekSpec;
import net.intelie.pipes.functions.SeqTransSpec;
import net.intelie.pipes.functions.TypeSpec;
import net.intelie.pipes.functions.UnfoldSpec;
import net.intelie.pipes.gson.Gson;
import net.intelie.pipes.util.GetUtils;
import net.intelie.pipes.util.ObjectHelper;
import net.intelie.pipes.util.SafeGson;

public abstract class ObjectOps {
    private static final Gson gson = SafeGson.create();

    @Help(key="operator-eq")
    @Representation(value="(%s==%s)")
    @Export(value={".eq"})
    public static Boolean eq(@TypeParam(enforce=false) Object lhs, @TypeParam(enforce=false) Object rhs) {
        return ObjectHelper.equals(lhs, rhs);
    }

    @Help(key="operator-neq")
    @Representation(value="(%s!=%s)")
    @Export(value={".neq"})
    public static Boolean neq(@TypeParam(enforce=false) Object lhs, @TypeParam(enforce=false) Object rhs) {
        return ObjectOps.eq(lhs, rhs) == false;
    }

    @Help(key="operator-transform")
    @Export(value={".transform"})
    @TypeParam(value={"ret"})
    @Representation(value="(%s |> %s)")
    public static Object transform(@Inject(value="scope()") Scope scope, @TypeParam(value={"seq"}) Iterable obj, @TypeParam(value={"ret"}) SeqTransSpec spec) {
        return spec.eval(scope, obj);
    }

    @Help(key="operator-peek")
    @Export(value={".peek"})
    @TypeParam(value={"ret"})
    @Representation(value="(%s->(%s))")
    public static Object peek(@Inject(value="scope()") Scope scope, @TypeParam(value={"peek"}) Object obj, @TypeParam(value={"ret"}) PeekSpec spec) {
        return spec.eval(scope, obj);
    }

    @Help(key="scalar-unfold")
    @Export
    @TypeParam(value={"ret"})
    public static Iterable unfold(@Inject(value="scope()") Scope scope, @TypeParam(value={"unfold"}) Object obj, @TypeParam(value={"ret"}) UnfoldSpec spec) {
        return spec.eval(scope, obj);
    }

    @Help(key="scalar-mapnames")
    @Export
    @TypeParam
    public static Row mapnames(@TypeParam MapNamesSpec spec) {
        return spec.value();
    }

    @Help(key="scalar-isin")
    @Export
    public static Boolean isin(@TypeParam Object obj, Object ... list) {
        return Arrays.asList(list).contains(obj);
    }

    @Help(key="scalar-indexin")
    @Export
    public static Double indexin(@TypeParam Object obj, Object ... list) {
        int i = Arrays.asList(list).indexOf(obj);
        if (i < 0) {
            return null;
        }
        return i;
    }

    @Help(key="scalar-cast")
    @Export
    @TypeParam
    public static Object cast(Object obj, @TypeParam TypeSpec spec) {
        return spec.cast(obj);
    }

    @Help(key="scalar-class")
    @Export(value={"class"})
    public static String _class(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.getClass().getName();
    }

    @Help(key="scalar-metadata")
    @Export
    @WithType(value="map(string, object)")
    public static Map metadata(MetadataSpec spec) {
        return spec.eval();
    }

    @Help(key="scalar-select")
    @Export
    @TypeParam
    public static Object select(Double index, Object ... list) {
        if (index == null) {
            return null;
        }
        int i = index.intValue();
        if (i < 0 || i >= list.length) {
            return null;
        }
        return list[i];
    }

    @Help(key="scalar-decode")
    @Export
    @TypeParam(value={"b"})
    public static Object decode(@TypeParam(value={"a"}) Object obj, Object ... list) {
        int i = 0;
        while (i + 1 < list.length) {
            if (Objects.equals(obj, list[i])) {
                return list[i + 1];
            }
            i += 2;
        }
        return null;
    }

    @Help(key="scalar-newmap")
    @Export
    @WithType(value="map($a, $b)")
    public static Map newmap(Object ... list) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int i = 0;
        while (i + 1 < list.length) {
            map.put(list[i], list[i + 1]);
            i += 2;
        }
        return map;
    }

    @Help(key="scalar-get")
    @Export(value={"get", ".get"})
    @TypeParam
    public static Object get(@TypeParam ObjectGetSpec spec, Object target, Object ... args) {
        return GetUtils.get((Object)target, (Object[])args);
    }

    @Help(key="scalar-len")
    @Export
    public static Double len(Object target) {
        return GetUtils.len((Object)target);
    }

    @Help(key="scalar-json")
    @Export
    public static String json(Object value) {
        return gson.toJson(value);
    }

    @Help(key="operator-coalesce")
    @Representation(value="(%s??%s)")
    @Export(value={".coalesce"})
    @TypeParam
    public static Object coalesce(@TypeParam(enforce=false) Object lhs, @TypeParam(enforce=false) Object rhs) {
        if (lhs == null) {
            return rhs;
        }
        return lhs;
    }
}

