/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.ConstantPropertySink;
import net.intelie.pipes.Literal;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Row;
import net.intelie.pipes.TypedCacheable;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.TimeoutString;
import net.intelie.pipes.util.regex.Matcher;
import net.intelie.pipes.util.regex.Pattern;

public class RegexSpec
implements TypedCacheable<Row>,
ConstantPropertySink {
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;
    private final int[] ids;
    private final RowType type;

    public RegexSpec(ArgQueue queue) throws PipeException {
        this((String)queue.constantValue((Type)Type.STRING).get());
    }

    public RegexSpec(String regex) throws PipeException {
        this.pattern = this.compile(regex);
        List<String> groupNames = this.pattern.groupNames();
        ArrayList<FieldInfo> patternFields = new ArrayList<FieldInfo>();
        this.ids = new int[groupNames.size()];
        for (int i = 0; i < groupNames.size(); ++i) {
            String s = groupNames.get(i);
            this.ids[i] = this.pattern.indexOf(s);
            patternFields.add(new FieldInfo(s, (Type)Type.STRING));
        }
        this.type = new RowType(new RowFields(new ClauseInfo(new FieldInfo[0]), new ClauseInfo(new FieldInfo[0]), new ClauseInfo(patternFields)));
    }

    private Pattern compile(String regex) throws PipeException {
        try {
            return Pattern.compile(regex);
        }
        catch (Throwable ex) {
            throw PipeException.handle((Throwable)ex);
        }
    }

    public String find(String str, int group) {
        if (group < 0) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(TimeoutString.wrap(str, 1000L));
        if (!matcher.find() || group > matcher.groupCount()) {
            return null;
        }
        return TimeoutString.unwrapToString(matcher.group(group));
    }

    public String find(String str, String group) {
        Matcher matcher = this.pattern.matcher(TimeoutString.wrap(str, 1000L));
        int index = this.pattern.indexOf(group);
        if (!matcher.find() || index < 0) {
            return null;
        }
        return TimeoutString.unwrapToString(matcher.group(index + 1));
    }

    public List<String> findall(String str, int group) {
        if (group < 0) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(TimeoutString.wrap(str, 1000L));
        if (group > matcher.groupCount()) {
            return null;
        }
        return this.extractValues(matcher, group);
    }

    public List<String> findall(String str, String group) {
        Matcher matcher = this.pattern.matcher(TimeoutString.wrap(str, 100000L));
        int index = this.pattern.indexOf(group);
        if (index < 0) {
            return null;
        }
        return this.extractValues(matcher, index + 1);
    }

    private List<String> extractValues(Matcher matcher, int group) {
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(TimeoutString.unwrapToString(matcher.group(group)));
        }
        return result;
    }

    public boolean matches(String str) {
        Matcher matcher = this.pattern.matcher(TimeoutString.wrap(str, 1000L));
        return matcher.find() && matcher.matches();
    }

    public String sub(String str, String replacement) {
        Matcher matcher = this.pattern.matcher(TimeoutString.wrap(str, 1000L));
        return TimeoutString.unwrapToString(matcher.replaceAll(replacement));
    }

    public List<String> split(String str, Double limit) {
        String[] splitted;
        ArrayList<String> result = new ArrayList<String>();
        for (String part : splitted = limit != null ? this.pattern.split(TimeoutString.wrap(str, 1000L), limit.intValue()) : this.pattern.split(TimeoutString.wrap(str, 1000L))) {
            result.add(TimeoutString.unwrapToString(part));
        }
        return result;
    }

    public Row regex(String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(TimeoutString.wrap(str, 1000L));
        if (!matcher.find()) {
            return null;
        }
        return this.extractRow(matcher);
    }

    public List<Row> regexall(String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(TimeoutString.wrap(str, 1000L));
        ArrayList<Row> rows = new ArrayList<Row>();
        while (matcher.find()) {
            rows.add(this.extractRow(matcher));
        }
        return rows;
    }

    private Row extractRow(Matcher matcher) {
        Object[] values = new Object[this.ids.length];
        for (int i = 0; i < this.ids.length; ++i) {
            values[i] = TimeoutString.unwrapToString(matcher.group(this.ids[i] + 1));
        }
        return new ArrayRow(values);
    }

    public Type<Row> type() {
        return this.type;
    }

    public String toString() {
        return Literal.newString((Object)this.pattern).toString();
    }
}

