/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.util.Arrays;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ConstantPropertySink;
import net.intelie.pipes.Expression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.TypedCacheable;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.ConcatIterable;

public class SeqConcatSpec
implements TypedCacheable,
ConstantPropertySink {
    private static final long serialVersionUID = 1L;
    private final Type type;

    public SeqConcatSpec(ArgQueue queue) throws PipeException {
        this(SeqConcatSpec.makeType(queue.copy()));
    }

    public SeqConcatSpec(Type type) {
        this.type = type;
    }

    private static Type makeType(ArgQueue copy) throws PipeException {
        return SeqConcatSpec.inferType(((Expression)copy.expression((Type)Type.SEQ).get()).type(), ((Expression)copy.expression((Type)Type.SEQ).get()).type());
    }

    public static Type inferType(Type typeA, Type typeB) throws PipeException {
        RowType extract1 = SeqConcatSpec.getRowType(typeA);
        RowType extract2 = SeqConcatSpec.getRowType(typeB);
        if (extract1 != null && extract2 != null) {
            return new RowType(new RowFields(extract1.fields().timestamp(), extract1.fields().group(), new ClauseInfo((Iterable)new ConcatIterable(Arrays.asList(extract1.fields().select(), extract2.fields())))));
        }
        return SeqConcatSpec.treatAsSeqs(typeA, typeB);
    }

    private static Type treatAsSeqs(Type typeA, Type typeB) throws PipeException {
        SeqType extract1 = SeqConcatSpec.getSeqType(typeA);
        SeqType extract2 = SeqConcatSpec.getSeqType(typeB);
        return new SeqType(Type.min((Type)extract1.type(), (Type)extract2.type()));
    }

    private static SeqType getSeqType(Type type) throws PipeException {
        SeqType seqType = (SeqType)Type.extract((Type)type, SeqType.class);
        if (seqType == null) {
            throw new PipeException("Unable to extract seq type from: %s", new Object[]{type});
        }
        return seqType;
    }

    private static RowType getRowType(Type type) throws PipeException {
        RowType rowType = (RowType)Type.extract((Type)type, RowType.class);
        if (rowType == null || rowType.fields() == null) {
            return null;
        }
        return rowType;
    }

    public Type type() {
        return this.type;
    }

    public boolean isRow() {
        return Type.extract((Type)this.type, RowType.class) != null;
    }

    public String toString() {
        return "";
    }
}

