/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.Representation;
import net.intelie.pipes.Row;
import net.intelie.pipes.TypeParam;
import net.intelie.pipes.Typed;
import net.intelie.pipes.WithType;
import net.intelie.pipes.functions.EnumerateSpec;
import net.intelie.pipes.functions.IterMapSpec;
import net.intelie.pipes.functions.SameSeqTypeSpec;
import net.intelie.pipes.functions.SeqConcatSpec;
import net.intelie.pipes.functions.ZipSpec;
import net.intelie.pipes.guava.collect.Iterables;
import net.intelie.pipes.guava.collect.Sets;
import net.intelie.pipes.util.ConcatIterable;
import net.intelie.pipes.util.EnumerateIterable;
import net.intelie.pipes.util.ExpRangeIterable;
import net.intelie.pipes.util.FilterIterable;
import net.intelie.pipes.util.RangeIterable;
import net.intelie.pipes.util.RepeatIterable;
import net.intelie.pipes.util.SliceIterable;

public abstract class SeqOps {
    @Help(key="operator-add-seq")
    @Export(value={".add"})
    @Representation(value="(%s+%s)")
    @TypeParam
    public static Iterable add(Iterable ita, Iterable itb, @TypeParam SeqConcatSpec spec) {
        ConcatIterable answer = new ConcatIterable(Arrays.asList(ita, itb));
        if (spec.isRow()) {
            answer = new ArrayRow(Iterables.toArray(answer, Object.class));
        }
        return answer;
    }

    @Help(key="scalar-seq-except")
    @Export(value={"except"})
    @TypeParam
    public static Iterable except(Iterable ita, Iterable itb, @TypeParam SameSeqTypeSpec spec) {
        if (ita == null || itb == null) {
            return null;
        }
        HashSet set = Sets.newHashSet(itb);
        return new FilterIterable<Object>(ita, x -> !set.contains(x));
    }

    @Help(key="scalar-seq-retain")
    @Export(value={"retain"})
    @TypeParam
    public static Iterable retain(Iterable ita, Iterable itb, @TypeParam SameSeqTypeSpec spec) {
        if (ita == null || itb == null) {
            return null;
        }
        HashSet set = Sets.newHashSet(itb);
        return new FilterIterable<Object>(ita, x -> set.contains(x));
    }

    @Help(key="scalar-seq-repeat")
    @Export
    @TypeParam
    public static Iterable repeat(Iterable it, Double count, @TypeParam SameSeqTypeSpec spec) {
        if (count == null || count.intValue() < 0 || it == null) {
            return null;
        }
        return new RepeatIterable(it, count.intValue());
    }

    @Help(key="scalar-skip")
    @Export
    @TypeParam
    public static Iterable skip(Iterable it, Double start, @TypeParam SameSeqTypeSpec spec) {
        return SeqOps.slice(it, start, null, null, spec);
    }

    @Help(key="scalar-take")
    @Export
    @TypeParam
    public static Iterable take(Iterable it, Double end, @TypeParam SameSeqTypeSpec spec) {
        return SeqOps.slice(it, null, end, null, spec);
    }

    @Help(key="scalar-slice")
    @Export
    @TypeParam
    public static Iterable slice(Iterable it, Double start, Double end, @TypeParam SameSeqTypeSpec spec) {
        return SeqOps.slice(it, start, end, null, spec);
    }

    @Help(key="scalar-slice")
    @Export
    @TypeParam
    public static Iterable slice(Iterable it, Double start, Double end, Double step, @TypeParam SameSeqTypeSpec spec) {
        if (it == null) {
            return null;
        }
        return new SliceIterable(it, start != null ? Long.valueOf(start.longValue()) : null, end != null ? Long.valueOf(end.longValue()) : null, step != null ? Long.valueOf(step.longValue()) : null);
    }

    @Help(key="scalar-qpush")
    @Export
    @Typed(value={"seq($a)"})
    public static Iterable qpush(@Typed(value={"seq($a)"}) Iterable ita, Object b) {
        return SeqOps.qpush(ita, b, null);
    }

    @Help(key="scalar-qpush")
    @Export
    @Typed(value={"seq($a)"})
    public static Iterable qpush(@Typed(value={"seq($a)"}) Iterable ita, Object b, Double max) {
        return SeqOps.qpushseq(ita, Collections.singletonList(b), max);
    }

    @Help(key="scalar-qpushseq")
    @Export
    @Typed(value={"seq($a)"})
    public static Iterable qpushseq(@Typed(value={"seq($a)"}) Iterable ita, @Typed(value={"seq($a)"}) Iterable itb) {
        return SeqOps.qpushseq(ita, itb, null);
    }

    @Help(key="scalar-qpushseq")
    @Export
    @Typed(value={"seq($a)"})
    public static Iterable qpushseq(@Typed(value={"seq($a)"}) Iterable ita, @Typed(value={"seq($a)"}) Iterable itb, Double max) {
        if (ita == null) {
            return null;
        }
        if (itb == null) {
            itb = new ArrayList();
        }
        ArrayDeque<Object> d = new ArrayDeque<Object>();
        SeqOps.pushMany(ita, max, d);
        if (max == null) {
            max = d.size();
        }
        SeqOps.pushMany(itb, max, d);
        return d;
    }

    static void pushMany(@Typed(value={"seq($a)"}) Iterable ita, Double max, ArrayDeque<Object> d) {
        for (Object o : ita) {
            if (o != null) {
                d.addLast(o);
            }
            while (max != null && (double)d.size() > max) {
                d.removeFirst();
            }
        }
    }

    @Help(key="scalar-zip")
    @Export
    @TypeParam
    public static Iterable zip(@TypeParam ZipSpec spec, Iterable ... its) {
        if (its == null) {
            return null;
        }
        return spec.eval(its);
    }

    @Help(key="scalar-range")
    @Export
    @WithType(value="seq(number)")
    public static Iterable<Double> range(Double start, Double end, Double step) {
        if (end == null) {
            return null;
        }
        if (start == null) {
            start = 0.0;
        }
        if (step == null) {
            step = 1.0;
        }
        return new RangeIterable(start, end, step);
    }

    @Help(key="scalar-range")
    @Export
    @WithType(value="seq(number)")
    public static Iterable<Double> range(Double start, Double end) {
        return SeqOps.range(start, end, null);
    }

    @Help(key="scalar-range")
    @Export
    @WithType(value="seq(number)")
    public static Iterable<Double> range(Double end) {
        return SeqOps.range(null, end, null);
    }

    @Help(key="scalar-exprange")
    @Export
    @WithType(value="seq(number)")
    public static Iterable<Double> exprange(Double start, Double end, Double step) {
        if (end == null) {
            return null;
        }
        if (start == null) {
            start = 1.0;
        }
        if (step == null) {
            step = 2.0;
        }
        return new ExpRangeIterable(start, end, step);
    }

    @Help(key="scalar-exprange")
    @Export
    @WithType(value="seq(number)")
    public static Iterable<Double> exprange(Double end, Double step) {
        return SeqOps.exprange(null, end, step);
    }

    @Help(key="scalar-enumerate")
    @Export
    @TypeParam
    public static Iterable enumerate(Iterable it, @TypeParam EnumerateSpec spec) {
        return SeqOps.enumerate(it, 0.0, spec);
    }

    @Help(key="scalar-enumerate")
    @Export
    @TypeParam
    public static Iterable enumerate(Iterable it, Double start, @TypeParam EnumerateSpec spec) {
        if (it == null) {
            return null;
        }
        EnumerateIterable answer = new EnumerateIterable(it, start != null ? start.intValue() : 0);
        if (it instanceof Row) {
            answer = new ArrayRow(Iterables.toArray(answer, Object.class));
        }
        return answer;
    }

    @Help(key="scalar-itermap")
    @Export
    @TypeParam(value={"ret"})
    public static Iterable itermap(@TypeParam(value={"itermap"}) Object obj, @TypeParam(value={"ret", "itermap"}) IterMapSpec spec) {
        return spec.eval(obj);
    }

    @Help(key="scalar-seq-contains")
    @Export
    public static Boolean contains(@Typed(value={"seq($a)"}) Iterable it, @Typed(value={"!a"}) Object toFind) {
        if (it == null) {
            return null;
        }
        return Iterables.contains(it, toFind);
    }

    @Help(key="scalar-seq-indexof")
    @Export
    public static Double indexof(@Typed(value={"seq($a)"}) Iterable it, @Typed(value={"!a"}) Object toFind) {
        if (it == null) {
            return null;
        }
        int value = Iterables.indexOf(it, x -> Objects.equals(x, toFind));
        if (value >= 0) {
            return value;
        }
        return null;
    }
}

