/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.util.ArrayList;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertySink;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SeqEvaluable;
import net.intelie.pipes.TypedCacheable;
import net.intelie.pipes.guava.collect.Iterables;
import net.intelie.pipes.modules.FallbackToSeqEvaluable;
import net.intelie.pipes.stateless.StatelessPipeEvaluable;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Preconditions;

public class SeqTransSpec
implements TypedCacheable,
PropertySink {
    private static final long serialVersionUID = 1L;
    private final SeqEvaluable expr;
    private final Type type;
    private final boolean special;

    public SeqTransSpec(ArgQueue queue, ResolverState state) throws PipeException {
        Type type = state.get("seq");
        SeqType seqType = (SeqType)Type.extract((Type)type, SeqType.class);
        if (seqType == null) {
            throw new PipeException("Must receive a seq as parameter Received: %s", new Object[]{type});
        }
        CompilerContext childContext = queue.context().newChildSource(queue.metadata().withType(seqType.type()).withSafe(true));
        this.expr = (SeqEvaluable)queue.withContext(childContext).getSafe(SeqEvaluable.class, (Fallback)new FallbackToSeqEvaluable());
        this.type = this.decideReturnType(type);
        this.special = !this.type.equals((Object)this.expr.type());
    }

    private Type decideReturnType(Type type) {
        if (this.expr.justMap() && RowType.hasFields((Type)type)) {
            RowFields fields = RowType.getFields((Type)type);
            SeqType seq = (SeqType)Type.extract((Type)this.expr.type(), SeqType.class);
            Preconditions.checkNotNull((Object)seq, (Object)"BUG: if justMap is set, the result should always be a seq(?)");
            return new RowType(new RowFields(SeqTransSpec.convertClause(seq.type(), fields.timestamp()), SeqTransSpec.convertClause(seq.type(), fields.group()), SeqTransSpec.convertClause(seq.type(), fields.select())));
        }
        return this.expr.type();
    }

    private static ClauseInfo convertClause(Type desiredType, ClauseInfo clause) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        for (FieldInfo info : clause) {
            fields.add(new FieldInfo(info.name(), desiredType));
        }
        return new ClauseInfo(fields);
    }

    public Object eval(Scope scope, Iterable obj) {
        Object eval = this.expr.eval(scope, obj);
        if (this.special && eval instanceof Iterable) {
            eval = new ArrayRow(Iterables.toArray((Iterable)eval, Object.class));
        }
        return eval;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return PropertyVisitor.visitChildScope((Scope)parent, (PropertyVisitor)visitor, (PropertySink)this.expr);
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        if (this.expr instanceof StatelessPipeEvaluable) {
            return ((StatelessPipeEvaluable)this.expr).toString(true);
        }
        return this.expr.toString();
    }
}

