/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.time.ZoneId;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Cacheable;
import net.intelie.pipes.ConstantPropertySink;
import net.intelie.pipes.Literal;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.modules.FallbackToConstant;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanParser;
import net.intelie.pipes.types.Type;

public class SpanSpec
implements Cacheable,
ConstantPropertySink {
    private static final long serialVersionUID = 1L;
    private final TimeSpan span;
    private final String spanText;
    private final String zoneText;

    public SpanSpec(ArgQueue queue) throws PipeException {
        try {
            this.spanText = (String)queue.constantValue((Type)Type.STRING).get();
            this.zoneText = (String)queue.constantValue((Type)Type.STRING).getOptional(new FallbackToConstant<Object>(null));
            this.span = new TimeSpanParser().parse(this.spanText, SpanSpec.makeZone(this.zoneText));
        }
        catch (Exception e) {
            throw new PipeException((Object)e.getMessage());
        }
    }

    public static ZoneId makeZone(String zone) throws PipeException {
        if (zone == null) {
            return null;
        }
        return ZoneId.of(zone);
    }

    public Double test(Double ref, Double toTest) {
        if (ref == null || toTest == null) {
            return null;
        }
        long start = this.span.start(ref.longValue());
        long end = this.span.end(ref.longValue());
        long test = toTest.longValue();
        return test < start ? -1.0 : (test >= end ? 1.0 : 0.0);
    }

    public Double start(Double ref) {
        if (ref == null) {
            return null;
        }
        return this.span.start(ref.longValue());
    }

    public Double end(Double ref) {
        if (ref == null) {
            return null;
        }
        return this.span.end(ref.longValue());
    }

    public ArrayRow eval(Double ref) {
        if (ref == null) {
            return new ArrayRow(new Object[]{null, null, null});
        }
        return new ArrayRow(new Object[]{ref, (double)this.span.start(ref.longValue()), (double)this.span.end(ref.longValue())});
    }

    public String toString() {
        return Literal.newString((Object)this.spanText) + (this.zoneText != null ? ", " + Literal.newString((Object)this.zoneText) : "");
    }
}

