/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.UUID;
import net.intelie.pipes.DoNotOptimize;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.Representation;
import net.intelie.pipes.Row;
import net.intelie.pipes.TypeParam;
import net.intelie.pipes.WithType;
import net.intelie.pipes.functions.RegexAllSpec;
import net.intelie.pipes.functions.RegexSpec;
import net.intelie.pipes.gson.Gson;
import net.intelie.pipes.guava.base.CharMatcher;
import net.intelie.pipes.guava.base.Splitter;
import net.intelie.pipes.guava.collect.Lists;
import net.intelie.pipes.util.BaseConverter;
import net.intelie.pipes.util.SafeGson;
import net.intelie.pipes.util.StringIterable;

public abstract class StringOps {
    private static final Gson gson = SafeGson.create();

    @Help(key="operator-add-string")
    @Representation(value="(%s+%s)")
    @Export(value={".add", "add"})
    public static String add(String lhs, String rhs) {
        if (lhs == null) {
            lhs = "";
        }
        if (rhs == null) {
            rhs = "";
        }
        return lhs + rhs;
    }

    @Help(key="scalar-concat")
    @Export(value={".concat", "concat"})
    public static String concat(String ... xs) {
        StringBuilder builder = new StringBuilder();
        for (String x : xs) {
            StringOps.append(builder, x);
        }
        return builder.toString();
    }

    private static void append(StringBuilder builder, String a) {
        if (a != null) {
            builder.append(a);
        }
    }

    @Help(key="scalar-sprintf")
    @Export
    public static String sprintf(String format, Object ... objs) {
        return String.format(Locale.US, format, objs);
    }

    @Help(key="scalar-stringrepeat")
    @Export
    public static String repeat(String s, Double count) {
        if (s == null || count == null || count.intValue() < 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count.intValue(); ++i) {
            builder.append(s);
        }
        return builder.toString();
    }

    @Help(key="scalar-split")
    @Export
    @WithType(value="seq(string)")
    public static Iterable<String> split(String s) {
        if (s == null) {
            return null;
        }
        return new StringIterable(s);
    }

    @Help(key="scalar-split")
    @Export
    @WithType(value="seq(string)")
    public static Iterable<String> split(String s, String delimiter) {
        return StringOps.split(s, delimiter, null);
    }

    @Help(key="scalar-split")
    @Export
    @WithType(value="seq(string)")
    public static Iterable<String> split(String s, String delimiter, Double limit) {
        if (s == null || delimiter == null) {
            return null;
        }
        Splitter splitter = Splitter.on(delimiter);
        if (limit != null) {
            splitter = splitter.limit(limit.intValue());
        }
        return Lists.newArrayList(splitter.split(s));
    }

    @Help(key="scalar-jsonparse")
    @Export
    public static Object jsonparse(String json) {
        if (json == null) {
            return null;
        }
        return gson.fromJson(json, Object.class);
    }

    @Help(key="scalar-regexsplit")
    @Export
    @WithType(value="seq(string)")
    public static Iterable<String> regexsplit(String s, RegexSpec regex) {
        return StringOps.regexsplit(s, regex, null);
    }

    @Help(key="scalar-regexsplit")
    @Export
    @WithType(value="seq(string)")
    public static Iterable<String> regexsplit(String s, RegexSpec regex, Double limit) {
        if (s == null) {
            return null;
        }
        return regex.split(s, limit);
    }

    @Help(key="scalar-ord")
    @Export
    public static Double ord(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return s.codePointAt(0);
    }

    @Help(key="scalar-chr")
    @Export
    public static String chr(Double d) {
        if (d == null || d < 0.0 || d > 1114111.0) {
            return null;
        }
        return new String(Character.toChars(d.intValue()));
    }

    @Help(key="scalar-upper")
    @Export
    public static String upper(String s) {
        if (s == null) {
            return null;
        }
        return s.toUpperCase(Locale.getDefault());
    }

    @Help(key="scalar-lower")
    @Export
    public static String lower(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase(Locale.getDefault());
    }

    @Help(key="scalar-trim")
    @Export
    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        return CharMatcher.whitespace().trimFrom(s);
    }

    @Help(key="scalar-trim")
    @Export
    public static String trim(String s, String chars) {
        if (chars == null) {
            return s;
        }
        if (s == null) {
            return null;
        }
        return CharMatcher.anyOf(chars).trimFrom(s);
    }

    @Help(key="scalar-ltrim")
    @Export
    public static String ltrim(String s) {
        if (s == null) {
            return null;
        }
        return CharMatcher.whitespace().trimLeadingFrom(s);
    }

    @Help(key="scalar-ltrim")
    @Export
    public static String ltrim(String s, String chars) {
        if (chars == null) {
            return s;
        }
        if (s == null) {
            return null;
        }
        return CharMatcher.anyOf(chars).trimLeadingFrom(s);
    }

    @Help(key="scalar-rtrim")
    @Export
    public static String rtrim(String s) {
        if (s == null) {
            return null;
        }
        return CharMatcher.whitespace().trimTrailingFrom(s);
    }

    @Help(key="scalar-rtrim")
    @Export
    public static String rtrim(String s, String chars) {
        if (chars == null) {
            return s;
        }
        if (s == null) {
            return null;
        }
        return CharMatcher.anyOf(chars).trimTrailingFrom(s);
    }

    @Help(key="scalar-contains")
    @Export
    public static Boolean contains(String s, String toFind) {
        return s != null && toFind != null && s.contains(toFind);
    }

    @Help(key="scalar-startswith")
    @Export
    public static Boolean startswith(String s, String toFind) {
        return s != null && toFind != null && s.startsWith(toFind);
    }

    @Help(key="scalar-endswith")
    @Export
    public static Boolean endswith(String s, String toFind) {
        return s != null && toFind != null && s.endsWith(toFind);
    }

    @Help(key="scalar-indexof")
    @Export
    public static Double indexof(String s, String toFind) {
        return StringOps.indexof(s, toFind, 0.0);
    }

    @Help(key="scalar-indexof")
    @Export
    public static Double indexof(String s, String toFind, Double fromIndex) {
        int i;
        if (s == null || toFind == null) {
            return null;
        }
        if (fromIndex == null) {
            fromIndex = 0.0;
        }
        if ((i = s.indexOf(toFind, fromIndex.intValue())) < 0) {
            return null;
        }
        return i;
    }

    @Help(key="scalar-rindexof")
    @Export
    public static Double rindexof(String s, String toFind) {
        return StringOps.rindexof(s, toFind, null);
    }

    @Help(key="scalar-rindexof")
    @Export
    public static Double rindexof(String s, String toFind, Double fromIndex) {
        int i;
        if (s == null || toFind == null) {
            return null;
        }
        if (fromIndex == null) {
            fromIndex = s.length();
        }
        if ((i = s.lastIndexOf(toFind, fromIndex.intValue())) < 0) {
            return null;
        }
        return i;
    }

    @Help(key="scalar-replace")
    @Export
    public static String replace(String s, String from, String to) {
        if (s == null || from == null || to == null) {
            return null;
        }
        return s.replace(from, to);
    }

    @Help(key="scalar-substring")
    @Export
    public static String substring(String s, Double from) {
        return StringOps.substring(s, from, null);
    }

    @Help(key="scalar-substring")
    @Export
    public static String substring(String s, Double from, Double to) {
        if (s == null) {
            return null;
        }
        if (from == null) {
            from = 0.0;
        }
        if (to == null) {
            to = s.length();
        }
        from = Math.max(Math.min(from, (double)s.length()), 0.0);
        to = Math.max(Math.min(to, (double)s.length()), from);
        return s.substring(from.intValue(), to.intValue());
    }

    @Help(key="scalar-truncate")
    @Export
    public static String truncate(String s, Double max) {
        return StringOps.truncate(s, max, "");
    }

    @Help(key="scalar-truncate")
    @Export
    public static String truncate(String s, Double max, String ellipsis) {
        if (s == null) {
            return null;
        }
        if (ellipsis == null) {
            ellipsis = "";
        }
        if (max == null || s.length() <= max.intValue()) {
            return s;
        }
        int value = max.intValue();
        if (ellipsis.length() > value) {
            ellipsis = ellipsis.substring(ellipsis.length() - value, ellipsis.length());
        }
        StringBuilder builder = new StringBuilder(value);
        builder.append(s, 0, value - ellipsis.length());
        builder.append(ellipsis);
        return builder.toString();
    }

    @Help(key="scalar-rtruncate")
    @Export
    public static String rtruncate(String s, Double max) {
        return StringOps.rtruncate(s, max, "");
    }

    @Help(key="scalar-rtruncate")
    @Export
    public static String rtruncate(String s, Double max, String ellipsis) {
        if (s == null) {
            return null;
        }
        if (ellipsis == null) {
            ellipsis = "";
        }
        if (max == null || s.length() <= max.intValue()) {
            return s;
        }
        int value = max.intValue();
        if (ellipsis.length() > value) {
            ellipsis = ellipsis.substring(ellipsis.length() - value, ellipsis.length());
        }
        StringBuilder builder = new StringBuilder(value);
        builder.append(ellipsis);
        builder.append(s, s.length() - value + ellipsis.length(), s.length());
        return builder.toString();
    }

    @Help(key="scalar-regexfind")
    @Export
    public static String regexfind(String s, RegexSpec regex) {
        return StringOps.regexfind(s, regex, 0.0);
    }

    @Help(key="scalar-regexfind")
    @Export
    public static String regexfind(String s, RegexSpec regex, Double index) {
        if (s == null) {
            return null;
        }
        if (index == null) {
            index = 0.0;
        }
        return regex.find(s, index.intValue());
    }

    @Help(key="scalar-regexfind")
    @Export
    public static String regexfind(String s, RegexSpec regex, String group) {
        if (s == null) {
            return null;
        }
        if (group == null) {
            return null;
        }
        return regex.find(s, group);
    }

    @Help(key="scalar-regexfindall")
    @Export
    @WithType(value="seq(string)")
    public static Iterable regexfindall(String s, RegexSpec regex) {
        return StringOps.regexfindall(s, regex, 0.0);
    }

    @Help(key="scalar-regexfindall")
    @WithType(value="seq(string)")
    @Export
    public static Iterable regexfindall(String s, RegexSpec regex, Double index) {
        if (s == null) {
            return null;
        }
        if (index == null) {
            index = 0.0;
        }
        return regex.findall(s, index.intValue());
    }

    @Help(key="scalar-regexfindall")
    @WithType(value="seq(string)")
    @Export
    public static Iterable regexfindall(String s, RegexSpec regex, String group) {
        if (s == null) {
            return null;
        }
        if (group == null) {
            return null;
        }
        return regex.findall(s, group);
    }

    @Help(key="scalar-regexmatch")
    @Export
    public static Boolean regexmatch(String s, RegexSpec regex) {
        return s != null && regex.matches(s);
    }

    @Help(key="scalar-regexsub")
    @Export
    public static String regexsub(String s, RegexSpec regex, String replacement) {
        if (s == null) {
            return null;
        }
        if (replacement == null) {
            return null;
        }
        return regex.sub(s, replacement);
    }

    @Help(key="scalar-regex")
    @Export
    @TypeParam
    public static Row regex(String s, @TypeParam RegexSpec regex) {
        return regex.regex(s);
    }

    @Help(key="scalar-regexall")
    @Export
    @TypeParam
    public static Iterable regexall(String s, @TypeParam RegexAllSpec regex) {
        return regex.regexall(s);
    }

    @Help(key="scalar-uuid")
    @Export
    @DoNotOptimize
    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    @Help(key="scalar-frombase")
    @Export
    public static Double frombase(String s, Double base) {
        if (s == null) {
            return null;
        }
        if (base == null) {
            return null;
        }
        return BaseConverter.fromBase(s, base.intValue());
    }

    @Help(key="scalar-tobase")
    @Export
    public static String tobase(Double x, Double base) {
        if (x == null) {
            return null;
        }
        if (base == null) {
            return null;
        }
        return BaseConverter.toBase(x.longValue(), base.intValue());
    }

    @Help(key="scalar-urldecode")
    @Export
    public static String urldecode(String s) {
        return StringOps.urldecode(s, "UTF-8");
    }

    @Help(key="scalar-urldecode")
    @Export
    public static String urldecode(String s, String enc) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Help(key="scalar-urlencode")
    @Export
    public static String urlencode(String s) {
        return StringOps.urlencode(s, "UTF-8");
    }

    @Help(key="scalar-urlencode")
    @Export
    public static String urlencode(String s, String enc) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, enc);
        }
        catch (Exception e) {
            return null;
        }
    }
}

