/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.ThreadMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.net.InetAddress;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Cacheable;
import net.intelie.pipes.ConstantPropertySink;
import net.intelie.pipes.DoNotOptimize;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.Row;
import net.intelie.pipes.TypeParam;
import net.intelie.pipes.TypedConstant;
import net.intelie.pipes.Version;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.MapType;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.ValueCache;

public abstract class SystemOps {
    public static final int ONE_MINUTE = 60000;
    public static final int FIVE_SECONDS = 5000;
    public static final int HALF_SECOND = 500;
    private static ValueCache<String> hostname = new ValueCache<String>(3600000L, "<unknown host>"){

        public String load() throws Exception {
            return InetAddress.getLocalHost().getHostName();
        }
    };

    @Help(key="scalar-sys-timestamp")
    @DoNotOptimize
    @Export(value={"sys.timestamp"})
    public static Double timestamp() {
        return System.currentTimeMillis();
    }

    @Help(key="scalar-sys-hostname")
    @DoNotOptimize
    @Export(value={"sys.hostname"})
    public static String hostname() {
        return (String)hostname.get();
    }

    @Help(key="scalar-sys-cpu")
    @TypeParam
    @DoNotOptimize
    @Export(value={"sys.cpu"})
    public static Row cpu(@TypeParam CpuSpec cpu) {
        return cpu.get();
    }

    @Help(key="scalar-sys-memory")
    @TypeParam
    @DoNotOptimize
    @Export(value={"sys.memory"})
    public static Row memory(@TypeParam MemorySpec heap) {
        return heap.get();
    }

    @Help(key="scalar-sys-heap")
    @TypeParam
    @DoNotOptimize
    @Export(value={"sys.heap"})
    public static Row heap(@TypeParam HeapSpec heap) {
        return heap.get();
    }

    @Help(key="scalar-sys-threads")
    @TypeParam
    @DoNotOptimize
    @Export(value={"sys.threads"})
    public static Row threads(@TypeParam ThreadsSpec threads) {
        return threads.get();
    }

    @Help(key="scalar-sys-threadlist")
    @TypeParam
    @DoNotOptimize
    @Export(value={"sys.threadlist"})
    public static Iterable threadlist(@TypeParam ThreadListSpec threads) {
        return threads.get();
    }

    @Help(key="scalar-sys-disks")
    @TypeParam
    @DoNotOptimize
    @Export(value={"sys.disks"})
    public static Iterable disks(@TypeParam DisksSpec disks) {
        return disks.get();
    }

    @Help(key="scalar-sys-fds")
    @TypeParam
    @DoNotOptimize
    @Export(value={"sys.fds"})
    public static Row fds(@TypeParam FdsSpec fds) {
        return fds.get();
    }

    @Help(key="scalar-sys-properties")
    @TypeParam
    @DoNotOptimize
    @Export(value={"sys.properties"})
    public static Object properties(@TypeParam SysPropsSpec props) {
        return props.get();
    }

    @Help(key="scalar-sys-version")
    @TypeParam
    @DoNotOptimize
    @Export(value={"sys.version"})
    public static Row version(@TypeParam VersionSpec spec) {
        return spec.get();
    }

    @Help(key="scalar-sys-uptime")
    @DoNotOptimize
    @Export(value={"sys.uptime"})
    public static Double uptime(UptimeSpec spec) {
        return spec.get();
    }

    private static abstract class MXBeanCache<T>
    extends ValueCache<T>
    implements ConstantPropertySink {
        private final OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        private final MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        private final ThreadMXBean thread = (ThreadMXBean)ManagementFactory.getThreadMXBean();
        private final RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();

        public MXBeanCache() {
            this(500L);
        }

        public MXBeanCache(long ttl) {
            super(ttl);
        }

        public abstract T load(OperatingSystemMXBean var1, MemoryMXBean var2, ThreadMXBean var3, RuntimeMXBean var4);

        public T load() throws Exception {
            return this.load(this.os, this.memory, this.thread, this.runtime);
        }
    }

    public static class VersionSpec
    extends TypedConstant<Row>
    implements ConstantPropertySink {
        private static final long serialVersionUID = 1L;
        private static ValueCache<Row> cache = new ValueCache<Row>(60000L){

            public Row load() throws Exception {
                Version current = Version.current();
                return new ArrayRow(new Object[]{current.major(), current.minor(), current.patch(), current.release()});
            }
        };

        public VersionSpec(ArgQueue queue) {
            super((Type)new RowType(new RowFields(null, null, new ClauseInfo(new FieldInfo[]{new FieldInfo("major", (Type)Type.NUMBER), new FieldInfo("minor", (Type)Type.NUMBER), new FieldInfo("patch", (Type)Type.NUMBER), new FieldInfo("release", (Type)Type.BOOLEAN)}))));
        }

        public Row get() {
            return (Row)cache.get();
        }
    }

    public static class SysPropsSpec
    extends TypedConstant<Map>
    implements ConstantPropertySink {
        private static final long serialVersionUID = 1L;
        private static ValueCache<Map> cache = new ValueCache<Map>(60000L){

            public Map load() throws Exception {
                return new LinkedHashMap<Object, Object>(System.getProperties());
            }
        };

        public SysPropsSpec(ArgQueue queue) {
            super((Type)new MapType((Type)Type.STRING, (Type)Type.OBJECT));
        }

        public Map get() {
            return (Map)cache.get();
        }
    }

    public static class FdsSpec
    extends TypedConstant<Row>
    implements ConstantPropertySink {
        private static final long serialVersionUID = 1L;
        private static ValueCache<Row> cache = new MXBeanCache<Row>(){

            @Override
            public Row load(OperatingSystemMXBean os, MemoryMXBean memory, ThreadMXBean thread, RuntimeMXBean runtime) {
                return FdsSpec.makeValue(os);
            }
        };

        public FdsSpec(ArgQueue queue) {
            super((Type)new RowType(new RowFields(null, null, new ClauseInfo(new FieldInfo[]{new FieldInfo("open", (Type)Type.NUMBER), new FieldInfo("max", (Type)Type.NUMBER)}))));
        }

        public static Row makeValue(OperatingSystemMXBean os) {
            if (os instanceof UnixOperatingSystemMXBean) {
                UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)os;
                return new ArrayRow(new Object[]{unix.getOpenFileDescriptorCount(), unix.getMaxFileDescriptorCount()});
            }
            return null;
        }

        public Row get() {
            return (Row)cache.get();
        }
    }

    public static class DisksSpec
    extends TypedConstant<Iterable>
    implements ConstantPropertySink {
        private static final long serialVersionUID = 1L;
        private static ValueCache<Iterable> cache = new ValueCache<Iterable>(5000L, Collections.emptyList()){

            public Iterable load() throws Exception {
                ArrayList<ArrayRow> list = new ArrayList<ArrayRow>();
                FileSystem fs = FileSystems.getDefault();
                for (FileStore store : fs.getFileStores()) {
                    list.add(new ArrayRow(new Object[]{store.name(), store.type(), store.isReadOnly(), (double)store.getUnallocatedSpace(), (double)store.getUsableSpace(), (double)store.getTotalSpace()}));
                }
                return list;
            }
        };

        public DisksSpec(ArgQueue queue) {
            super((Type)new SeqType((Type)new RowType(new RowFields(null, null, new ClauseInfo(new FieldInfo[]{new FieldInfo("name", (Type)Type.STRING), new FieldInfo("type", (Type)Type.STRING), new FieldInfo("readonly", (Type)Type.BOOLEAN), new FieldInfo("unallocated", (Type)Type.NUMBER), new FieldInfo("usable", (Type)Type.NUMBER), new FieldInfo("total", (Type)Type.NUMBER)})))));
        }

        public Iterable get() {
            return (Iterable)cache.get();
        }
    }

    public static class ThreadListSpec
    extends TypedConstant<Iterable>
    implements ConstantPropertySink {
        private static final long serialVersionUID = 1L;
        public static ValueCache<Iterable> cache = new MXBeanCache<Iterable>(5000L){

            @Override
            public Iterable load(OperatingSystemMXBean os, MemoryMXBean memory, ThreadMXBean thread, RuntimeMXBean runtime) {
                ThreadInfo[] infos = thread.dumpAllThreads(false, false);
                long[] ids = new long[infos.length];
                for (int i = 0; i < infos.length; ++i) {
                    ids[i] = infos[i].getThreadId();
                }
                long[] times = thread.getThreadCpuTime(ids);
                ArrayList<ArrayRow> list = new ArrayList<ArrayRow>();
                for (int i = 0; i < infos.length; ++i) {
                    ThreadInfo info = infos[i];
                    list.add(new ArrayRow(new Object[]{(double)ids[i], info.getThreadName(), (double)times[i] / 1.0E9, String.valueOf((Object)info.getThreadState()), info.getLockName(), (double)info.getLockOwnerId(), info.getLockOwnerName()}));
                }
                return list;
            }
        };

        public ThreadListSpec(ArgQueue queue) {
            super((Type)new SeqType((Type)new RowType(new RowFields(null, null, new ClauseInfo(new FieldInfo[]{new FieldInfo("id", (Type)Type.NUMBER), new FieldInfo("name", (Type)Type.STRING), new FieldInfo("cputime", (Type)Type.NUMBER), new FieldInfo("state", (Type)Type.STRING), new FieldInfo("lockname", (Type)Type.STRING), new FieldInfo("lockownerid", (Type)Type.NUMBER), new FieldInfo("lockowner", (Type)Type.STRING)})))));
        }

        public Iterable get() {
            return (Iterable)cache.get();
        }
    }

    public static class ThreadsSpec
    extends TypedConstant<Row>
    implements ConstantPropertySink {
        private static final long serialVersionUID = 1L;
        public static ValueCache<Row> cache = new MXBeanCache<Row>(){

            @Override
            public Row load(OperatingSystemMXBean os, MemoryMXBean memory, ThreadMXBean thread, RuntimeMXBean runtime) {
                long[] deadlocked = thread.findDeadlockedThreads();
                return new ArrayRow(new Object[]{(double)thread.getThreadCount(), (double)thread.getPeakThreadCount(), (double)thread.getTotalStartedThreadCount(), (double)thread.getDaemonThreadCount(), (double)(deadlocked != null ? deadlocked.length : 0)});
            }
        };

        public ThreadsSpec(ArgQueue queue) {
            super((Type)new RowType(new RowFields(null, null, new ClauseInfo(new FieldInfo[]{new FieldInfo("running", (Type)Type.NUMBER), new FieldInfo("peak", (Type)Type.NUMBER), new FieldInfo("total", (Type)Type.NUMBER), new FieldInfo("daemon", (Type)Type.NUMBER), new FieldInfo("deadlocked", (Type)Type.NUMBER)}))));
        }

        public Row get() {
            return (Row)cache.get();
        }
    }

    public static class HeapSpec
    extends TypedConstant<Row>
    implements ConstantPropertySink {
        private static final long serialVersionUID = 1L;
        private static ValueCache<Row> cache = new MXBeanCache<Row>(){

            @Override
            public Row load(OperatingSystemMXBean os, MemoryMXBean memory, ThreadMXBean thread, RuntimeMXBean runtime) {
                MemoryUsage usage = memory.getHeapMemoryUsage();
                return new ArrayRow(new Object[]{(double)usage.getUsed(), (double)usage.getMax(), (double)usage.getCommitted()});
            }
        };

        public HeapSpec(ArgQueue queue) {
            super((Type)new RowType(new RowFields(null, null, new ClauseInfo(new FieldInfo[]{new FieldInfo("used", (Type)Type.NUMBER), new FieldInfo("max", (Type)Type.NUMBER), new FieldInfo("committed", (Type)Type.NUMBER)}))));
        }

        public Row get() {
            return (Row)cache.get();
        }
    }

    public static class MemorySpec
    extends TypedConstant<Row>
    implements ConstantPropertySink {
        private static final long serialVersionUID = 1L;
        private static ValueCache<Row> cache = new MXBeanCache<Row>(){

            @Override
            public Row load(OperatingSystemMXBean os, MemoryMXBean memory, ThreadMXBean thread, RuntimeMXBean runtime) {
                long free = os.getFreePhysicalMemorySize();
                long total = os.getTotalPhysicalMemorySize();
                long freeswap = os.getFreeSwapSpaceSize();
                long totalswap = os.getTotalSwapSpaceSize();
                return new ArrayRow(new Object[]{(double)total - (double)free, (double)total, (double)totalswap - (double)freeswap, (double)totalswap});
            }
        };

        public MemorySpec(ArgQueue queue) {
            super((Type)new RowType(new RowFields(null, null, new ClauseInfo(new FieldInfo[]{new FieldInfo("used", (Type)Type.NUMBER), new FieldInfo("total", (Type)Type.NUMBER), new FieldInfo("usedswap", (Type)Type.NUMBER), new FieldInfo("totalswap", (Type)Type.NUMBER)}))));
        }

        public Row get() {
            return (Row)cache.get();
        }
    }

    public static class UptimeSpec
    implements Cacheable,
    ConstantPropertySink {
        private static final long serialVersionUID = 1L;
        private static ValueCache<Double> cache = new MXBeanCache<Double>(){

            @Override
            public Double load(OperatingSystemMXBean os, MemoryMXBean memory, ThreadMXBean thread, RuntimeMXBean runtime) {
                return runtime.getUptime();
            }
        };

        public UptimeSpec(ArgQueue queue) {
        }

        public Double get() {
            return (Double)cache.get();
        }
    }

    public static class CpuSpec
    extends TypedConstant<Row>
    implements ConstantPropertySink {
        private static final long serialVersionUID = 1L;
        private static ValueCache<Row> cache = new MXBeanCache<Row>(){

            @Override
            public Row load(OperatingSystemMXBean os, MemoryMXBean memory, ThreadMXBean thread, RuntimeMXBean runtime) {
                return new ArrayRow(new Object[]{os.getProcessCpuLoad(), os.getSystemCpuLoad(), os.getSystemLoadAverage(), (double)os.getAvailableProcessors()});
            }
        };

        public CpuSpec(ArgQueue queue) {
            super((Type)new RowType(new RowFields(null, null, new ClauseInfo(new FieldInfo[]{new FieldInfo("process", (Type)Type.NUMBER), new FieldInfo("system", (Type)Type.NUMBER), new FieldInfo("loadavg", (Type)Type.NUMBER), new FieldInfo("cores", (Type)Type.NUMBER)}))));
        }

        public Row get() {
            return (Row)cache.get();
        }
    }
}

