/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Evaluable;
import net.intelie.pipes.Export;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"timestamp"})
@Help(key="scalar-timestamp")
public class TimestampFunction
implements Scalar<Double> {
    private static final long serialVersionUID = 1L;
    private final Evaluable<Double> timestamp;

    public TimestampFunction(ArgQueue queue) throws PipeException {
        this((Evaluable<Double>)queue.context().timestamp());
    }

    public TimestampFunction(Evaluable<Double> timestamp) throws PipeException {
        this.timestamp = timestamp;
    }

    public State newState(int flips) {
        return new MyState();
    }

    public FullMerger newMerger() {
        return new MyMerger();
    }

    public InsertMerger newInsertMerger() {
        return new MyMerger();
    }

    public Type<Double> type() {
        return Type.NUMBER;
    }

    public Level level() {
        return Level.SCALAR;
    }

    public Double eval(Scope parent, Object obj) {
        return (Double)this.timestamp.eval(parent, obj);
    }

    public long ttl() {
        return 1L;
    }

    public long weight() {
        return 0L;
    }

    public void validate(ValidationContext context) throws PipeException {
    }

    public String toString() {
        return "timestamp()";
    }

    public Double eval(Scope parent, Tree tree, WindowBounds bounds) {
        Long timestamp = bounds != null ? bounds.timestamp() : null;
        return timestamp != null ? Double.valueOf(timestamp.doubleValue()) : null;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.timestamp.visit(parent, visitor);
    }

    private class MyState
    implements State {
        private MyState() {
        }

        public void yield(Scope parent, Object obj) {
        }

        public Tree flip() {
            return null;
        }
    }

    private class MyMerger
    implements FullMerger,
    InsertMerger {
        private MyMerger() {
        }

        public void push(Tree tree) {
        }

        public void pop() {
        }

        public void clear() {
        }

        public Tree get() {
            return null;
        }
    }
}

