/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.util.LinkedHashSet;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertySink;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.TypedCacheable;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.UnfoldIterable;

public class UnfoldSpec
implements TypedCacheable,
PropertySink {
    private static final long serialVersionUID = 1L;
    private final Scalar<Row> expr;
    private final Type type;
    private final Type stateType;

    public UnfoldSpec(ArgQueue queue, ResolverState state) throws PipeException {
        Type stateType = state.get("unfold");
        Scalar<Row> expression = this.compileExpression(queue.copyFromHere(), stateType);
        RowFields rowFields = this.decideRowFields(expression);
        LinkedHashSet<Type> set = new LinkedHashSet<Type>();
        set.add(stateType);
        try {
            int tries = 0;
            while (!rowFields.type(1).isAssignableTo(stateType)) {
                stateType = ++tries < 4 ? Type.min((Type)stateType, (Type)rowFields.type(1)) : Type.OBJECT;
                set.add(stateType);
                expression = this.compileExpression(queue.copyFromHere(), stateType);
                rowFields = this.decideRowFields(expression);
            }
            queue.get(AstNode.class);
        }
        catch (PipeException e) {
            throw new PipeException("Could not find suitable state type. Tried: %s, last cause:\n%s", new Object[]{Iterables.join((String)", ", set), e.getMessage()});
        }
        this.expr = expression;
        this.type = new SeqType(rowFields.type(0));
        this.stateType = stateType;
    }

    private Scalar<Row> compileExpression(ArgQueue queue, Type stateType) throws PipeException {
        CompilerContext childContext = queue.context().newChildSource(queue.metadata().withType(stateType).withSafe(true));
        return (Scalar)queue.withContext(childContext).scalar((Type)Type.ROW).get();
    }

    private RowFields decideRowFields(Scalar<Row> expression) throws PipeException {
        RowType rowType = (RowType)Type.extract((Type)expression.type(), RowType.class);
        RowFields rowFields = rowType.fields();
        if (rowFields == null || rowFields.size() != 2) {
            throw new PipeException("Invalid return type: %s. It must be a row with two fields.", new Object[]{rowType});
        }
        return rowFields;
    }

    public Iterable eval(Scope scope, Object initialState) {
        return new UnfoldIterable(scope, initialState, this.expr);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return PropertyVisitor.visitChildScope((Scope)parent, (PropertyVisitor)visitor, this.expr);
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return this.expr.toString();
    }

    public Type stateType() {
        return this.stateType;
    }
}

