/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.ConstantPropertySink;
import net.intelie.pipes.Expression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Row;
import net.intelie.pipes.TypedCacheable;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

public class ZipSpec
implements TypedCacheable<Iterable>,
ConstantPropertySink {
    private static final long serialVersionUID = 1L;
    private final SeqType type;

    public ZipSpec(ArgQueue queue) throws PipeException {
        queue = queue.copy();
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        int index = 0;
        while (queue.hasNext()) {
            fields.add(new FieldInfo("value" + ++index, SeqType.getInnerType((Type)((Expression)queue.expression((Type)Type.SEQ).get()).type())));
        }
        this.type = new SeqType((Type)new RowType(new RowFields(new ClauseInfo(fields))));
    }

    public Iterable eval(Iterable ... iterables) {
        return new ZipIterable(Arrays.asList(iterables));
    }

    public Type<Iterable> type() {
        return this.type;
    }

    public String toString() {
        return "";
    }

    private static class ZipIterable
    implements Iterable<Row>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Iterable<Object>> iterables;

        public ZipIterable(List<Iterable<Object>> iterables) {
            this.iterables = iterables;
        }

        @Override
        public Iterator<Row> iterator() {
            final ArrayList iterators = new ArrayList();
            for (Iterable<Object> iterable : this.iterables) {
                iterators.add(iterable != null ? iterable.iterator() : Collections.emptyIterator());
            }
            return new Iterator<Row>(){

                @Override
                public boolean hasNext() {
                    boolean hasNext = true;
                    for (Iterator iterator : iterators) {
                        hasNext = hasNext && iterator.hasNext();
                    }
                    return hasNext;
                }

                @Override
                public Row next() {
                    int size = iterators.size();
                    Object[] values = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        Iterator iterator = (Iterator)iterators.get(i);
                        if (iterator == null) continue;
                        values[i] = iterator.next();
                    }
                    return new ArrayRow(values);
                }
            };
        }
    }
}

