/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.gson.internal.bind;

import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.intelie.pipes.gson.Gson;
import net.intelie.pipes.gson.JsonSyntaxException;
import net.intelie.pipes.gson.TypeAdapter;
import net.intelie.pipes.gson.TypeAdapterFactory;
import net.intelie.pipes.gson.reflect.TypeToken;
import net.intelie.pipes.gson.stream.JsonReader;
import net.intelie.pipes.gson.stream.JsonToken;
import net.intelie.pipes.gson.stream.JsonWriter;

public final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    @Override
    public synchronized Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            long utilDate = this.format.parse(in.nextString()).getTime();
            return new Date(utilDate);
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

