/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.guava.collect;

import java.util.NoSuchElementException;
import net.intelie.pipes.checkerframework.checker.nullness.qual.Nullable;
import net.intelie.pipes.guava.annotations.GwtCompatible;
import net.intelie.pipes.guava.collect.UnmodifiableIterator;

@GwtCompatible
public abstract class AbstractSequentialIterator<T>
extends UnmodifiableIterator<T> {
    private @Nullable T nextOrNull;

    protected AbstractSequentialIterator(@Nullable T firstOrNull) {
        this.nextOrNull = firstOrNull;
    }

    protected abstract T computeNext(T var1);

    @Override
    public final boolean hasNext() {
        return this.nextOrNull != null;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.nextOrNull;
            return t;
        }
        finally {
            this.nextOrNull = this.computeNext(this.nextOrNull);
        }
    }
}

