/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.guava.collect;

import java.io.Serializable;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import net.intelie.pipes.checkerframework.checker.nullness.qual.Nullable;
import net.intelie.pipes.guava.annotations.GwtCompatible;
import net.intelie.pipes.guava.annotations.GwtIncompatible;
import net.intelie.pipes.guava.base.Preconditions;
import net.intelie.pipes.guava.collect.CollectSpliterators;
import net.intelie.pipes.guava.collect.ImmutableAsList;
import net.intelie.pipes.guava.collect.ImmutableCollection;
import net.intelie.pipes.guava.collect.ImmutableList;
import net.intelie.pipes.guava.collect.ImmutableMap;
import net.intelie.pipes.guava.collect.ImmutableSet;
import net.intelie.pipes.guava.collect.Iterators;
import net.intelie.pipes.guava.collect.UnmodifiableIterator;
import net.intelie.pipes.j2objc.annotations.Weak;

@GwtCompatible(emulated=true)
final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    @Weak
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<V> iterator() {
        return new UnmodifiableIterator<V>(){
            final UnmodifiableIterator<Map.Entry<K, V>> entryItr;
            {
                this.entryItr = ((ImmutableSet)ImmutableMapValues.this.map.entrySet()).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryItr.hasNext();
            }

            @Override
            public V next() {
                return ((Map.Entry)this.entryItr.next()).getValue();
            }
        };
    }

    @Override
    public Spliterator<V> spliterator() {
        return CollectSpliterators.map(((ImmutableCollection)((Object)this.map.entrySet())).spliterator(), Map.Entry::getValue);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return object != null && Iterators.contains(this.iterator(), object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    public ImmutableList<V> asList() {
        final ImmutableList entryList = ((ImmutableSet)this.map.entrySet()).asList();
        return new ImmutableAsList<V>(){

            @Override
            public V get(int index) {
                return ((Map.Entry)entryList.get(index)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return ImmutableMapValues.this;
            }
        };
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super V> action) {
        Preconditions.checkNotNull(action);
        this.map.forEach((? super K k, ? super V v) -> action.accept((Object)v));
    }

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new SerializedForm<V>(this.map);
    }

    @GwtIncompatible
    private static class SerializedForm<V>
    implements Serializable {
        final ImmutableMap<?, V> map;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, V> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.values();
        }
    }
}

