/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.guava.collect;

import java.util.Set;
import net.intelie.pipes.checkerframework.checker.nullness.qual.Nullable;
import net.intelie.pipes.guava.annotations.GwtCompatible;
import net.intelie.pipes.guava.collect.ImmutableList;
import net.intelie.pipes.guava.collect.IndexedImmutableSet;

@GwtCompatible(serializable=true)
final class JdkBackedImmutableSet<E>
extends IndexedImmutableSet<E> {
    private final Set<?> delegate;
    private final ImmutableList<E> delegateList;

    JdkBackedImmutableSet(Set<?> delegate, ImmutableList<E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    @Override
    E get(int index) {
        return this.delegateList.get(index);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.delegate.contains(object);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.delegateList.size();
    }
}

