/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.jitescript;

import java.util.ArrayList;
import net.intelie.pipes.jitescript.CodeBlock;
import net.intelie.pipes.jitescript.VisibleAnnotation;
import net.intelie.pipes.jitescript.internal.org.objectweb.asm.tree.LocalVariableNode;
import net.intelie.pipes.jitescript.internal.org.objectweb.asm.tree.MethodNode;
import net.intelie.pipes.jitescript.internal.org.objectweb.asm.tree.TryCatchBlockNode;

public class MethodDefinition {
    private final String methodName;
    private final int modifiers;
    private final String signature;
    private final CodeBlock methodBody;

    public MethodDefinition(String methodName, int modifiers, String signature, CodeBlock methodBody) {
        this.methodName = methodName;
        this.modifiers = modifiers;
        this.signature = signature;
        this.methodBody = methodBody;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public CodeBlock getMethodBody() {
        return this.methodBody;
    }

    public String getSignature() {
        return this.signature;
    }

    public MethodNode getMethodNode() {
        MethodNode method = new MethodNode(this.getModifiers(), this.getMethodName(), this.getSignature(), null, null);
        method.visibleAnnotations = new ArrayList();
        method.instructions.add(this.getMethodBody().getInstructionList());
        for (TryCatchBlockNode tryCatchBlockNode : this.getMethodBody().getTryCatchBlockList()) {
            method.tryCatchBlocks.add(tryCatchBlockNode);
        }
        for (LocalVariableNode localVariableNode : this.getMethodBody().getLocalVariableList()) {
            method.localVariables.add(localVariableNode);
        }
        for (VisibleAnnotation annotation : this.methodBody.getAnnotations()) {
            method.visibleAnnotations.add(annotation.getNode());
        }
        return method;
    }
}

