/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.jitescript;

import net.intelie.pipes.jitescript.AnnotationArrayValue;
import net.intelie.pipes.jitescript.internal.org.objectweb.asm.AnnotationVisitor;
import net.intelie.pipes.jitescript.internal.org.objectweb.asm.tree.AnnotationNode;
import net.intelie.pipes.jitescript.util.CodegenUtils;

public class VisibleAnnotation {
    private final AnnotationVisitor node;

    public VisibleAnnotation(Class<?> type) {
        this(CodegenUtils.ci(type));
    }

    public VisibleAnnotation(String desc) {
        this.node = new AnnotationNode(desc);
    }

    private VisibleAnnotation(AnnotationVisitor node) {
        this.node = node;
    }

    public AnnotationNode getNode() {
        return (AnnotationNode)this.node;
    }

    public VisibleAnnotation value(String name, Object value) {
        this.node.visit(name, value);
        return this;
    }

    public VisibleAnnotation enumValue(String name, Enum value) {
        this.enumValue(name, CodegenUtils.ci(value.getClass()), value.name());
        return this;
    }

    public VisibleAnnotation enumValue(String name, String desc, String value) {
        this.node.visitEnum(name, desc, value);
        return this;
    }

    public VisibleAnnotation annotationValue(String name, Class<?> type) {
        return this.annotationValue(name, CodegenUtils.ci(type));
    }

    public VisibleAnnotation annotationValue(String name, String desc) {
        return new VisibleAnnotation(this.node.visitAnnotation(name, desc));
    }

    public AnnotationArrayValue arrayValue(String name) {
        return new AnnotationArrayValue(name, this.node.visitArray(name));
    }

    public AnnotationArrayValue arrayValue(String name, Object ... values) {
        AnnotationArrayValue array = this.arrayValue(name);
        for (Object value : values) {
            array.add(value);
        }
        return array;
    }
}

