/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Row;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

@Export(value={".argmod"})
@Help(omit=true)
public class ArgumentModifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<ArgumentModifier> children;
    private final int size;

    public ArgumentModifier(ArgQueue queue) throws PipeException {
        this((String)queue.constantValue((Type)Type.STRING).getSafe(), Arrays.asList(queue.array(ArgumentModifier.class)));
    }

    public ArgumentModifier(String name) {
        this(name, null);
    }

    public ArgumentModifier(List<ArgumentModifier> children) {
        this(null, children);
    }

    private ArgumentModifier(String name, List<ArgumentModifier> children) {
        this.name = name;
        this.children = children;
        this.size = this.makeSize(name, children);
    }

    private int makeSize(String name, List<ArgumentModifier> children) {
        int size;
        int n = size = name != null ? 1 : 0;
        if (children != null) {
            for (ArgumentModifier child : children) {
                size += child.size();
            }
        }
        return size;
    }

    public int size() {
        return this.size;
    }

    public Row modify(Object value) {
        Object[] values = new Object[this.size];
        this.modify(values, 0, value);
        return new ArrayRow(values);
    }

    private void modify(Object[] values, int i, Object value) {
        if (this.name != null) {
            values[i++] = value;
        }
        if (this.children != null && this.children.size() > 0) {
            Row row = value instanceof Row ? (Row)value : null;
            for (int j = 0; j < this.children.size(); ++j) {
                ArgumentModifier child = this.children.get(j);
                child.modify(values, i, row != null && j < row.size() ? row.get(j) : null);
                i += child.size();
            }
        }
    }

    public RowType decideType(Type originalType) throws PipeException {
        ArrayList<FieldInfo> list = new ArrayList<FieldInfo>();
        this.decideType(originalType, list);
        return new RowType(new RowFields(new ClauseInfo(list)));
    }

    private void decideType(Type originalType, List<FieldInfo> list) throws PipeException {
        if (this.name != null) {
            list.add(new FieldInfo(this.name, originalType));
        }
        if (this.children != null && this.children.size() > 0) {
            RowType rowType = (RowType)Type.extract((Type)originalType, RowType.class);
            if (rowType == null || rowType.fields() == null) {
                throw new PipeException("Unable to expand type '%s' as %s: not a row type", new Object[]{originalType, this});
            }
            RowFields fields = rowType.fields();
            if (fields.size() != this.children.size()) {
                throw new PipeException("Unable to expand type '%s' as %s: different sizes", new Object[]{originalType, this});
            }
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).decideType(fields.type(i), list);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.name != null) {
            builder.append(this.name);
        }
        if (this.children != null && this.children.size() > 0) {
            builder.append('(').append(Iterables.join((String)", ", this.children)).append(')');
        }
        return builder.toString();
    }
}

