/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Hintable;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SimpleMerger;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

public class Cast<T>
implements Scalar<T> {
    private static final long serialVersionUID = 1L;
    private final Expression<?> operand;
    private final Type<T> type;

    public Cast(Expression<?> operand, Type<T> type) throws PipeException {
        this.operand = Cast.maybeHint(operand, type);
        this.type = type;
    }

    private static Expression maybeHint(Expression operand, Type type) throws PipeException {
        if (operand instanceof Hintable) {
            return (Expression)((Hintable)operand).hint(type);
        }
        return operand;
    }

    public static String makeString(Type type, Object operand) {
        return type.makeString(operand);
    }

    public State newState(int flips) {
        return new MyState(Level.asAggregation(this.operand).newState(flips));
    }

    public FullMerger newMerger() {
        return SimpleMerger.makeFullMerger((SimpleMerger)new MyMerger(Level.asAggregation(this.operand).newMerger()));
    }

    public InsertMerger newInsertMerger() {
        return SimpleMerger.makeInsertMerger((SimpleMerger)new MyMerger(Level.asAggregation(this.operand).newMerger()));
    }

    public Type<T> type() {
        return this.type;
    }

    public Level level() {
        return this.operand.level();
    }

    public T eval(Scope parent, Object obj) {
        return (T)this.type.cast(Level.asScalar(this.operand).eval(parent, obj));
    }

    public long ttl() {
        return this.operand.ttl();
    }

    public long weight() {
        return this.operand.weight() + 8L;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.operand});
    }

    public String toString() {
        return Cast.makeString(this.type, this.operand);
    }

    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        MyTree myTree = (MyTree)tree;
        return (T)this.type.cast(Level.asAggregation(this.operand).eval(parent, myTree.operand, bounds));
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.operand.visit(parent, visitor);
    }

    private class MyState
    implements State {
        private final State operand;

        public MyState(State operand) {
            this.operand = operand;
        }

        public void yield(Scope parent, Object obj) {
            this.operand.yield(parent, obj);
        }

        public Tree flip() {
            return new MyTree(this.operand.flip());
        }
    }

    private class MyMerger
    extends SimpleMerger.Base<MyTree<T>> {
        private final FullMerger merger;

        private MyMerger(FullMerger merger) {
            this.merger = merger;
        }

        public void addQ(MyTree<T> tree) {
            this.merger.push(tree.operand);
        }

        public void removeQ(MyTree<T> tree) {
            this.merger.pop();
        }

        public void clear() {
            this.merger.clear();
        }

        public MyTree<T> get() {
            return new MyTree(this.merger.get());
        }
    }

    private static class MyTree<T>
    implements Tree {
        private static final long serialVersionUID = 1L;
        private final Tree operand;

        public MyTree(Tree operand) {
            this.operand = operand;
        }
    }
}

