/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Function;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Documentation;

public class CompileIfFunction
implements Function {
    private static final long serialVersionUID = 1L;

    public Object declare(ArgQueue queue) throws PipeException {
        Boolean condition = (Boolean)queue.constantValue((Type)Type.BOOLEAN).get();
        AstNode lhs = (AstNode)queue.get(AstNode.class);
        AstNode rhs = (AstNode)queue.get(AstNode.class);
        return queue.context().compile(Boolean.TRUE.equals(condition) ? lhs : rhs);
    }

    public String name() {
        return "compile.if";
    }

    public String description() {
        return "compile.if(condition, if_true, if_false)";
    }

    public HelpData help() {
        return Documentation.current().makeHelp("compile.if", "scalar-compile-if");
    }
}

