/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.ArrayList;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Function;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.MacroModule;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeCompiler;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.CallNode;
import net.intelie.pipes.ast.RawNode;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Documentation;

public class CompileMapFunction
implements Function {
    private static final long serialVersionUID = 1L;

    public Object declare(ArgQueue queue) throws PipeException {
        return CompileMapFunction.declare(queue, queue.compiler().expression());
    }

    public static <T> T declare(ArgQueue queue, PipeCompiler<T> compiler) throws PipeException {
        String expr = (String)queue.constantValue((Type)Type.STRING).getSafe();
        AstNode node = expr != null ? compiler.parse(expr) : (AstNode)queue.get(AstNode.class);
        ArrayList<RawNode> nodes = new ArrayList<RawNode>();
        while (queue.hasNext()) {
            MacroModule module = MacroModule.fromAstNodes((AstNode[])new AstNode[]{(AstNode)queue.get(AstNode.class)});
            nodes.add(new RawNode(compiler.withModule((Module)module).compile(node)));
        }
        return (T)compiler.compile((AstNode)new CallNode(queue.location(), ".row", nodes));
    }

    public String name() {
        return "compile.map";
    }

    public String description() {
        return "compile.map(string)";
    }

    public HelpData help() {
        return Documentation.current().makeHelp("compile.map", "scalar-compile-map");
    }
}

