/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;

@Export(value={"const"})
@Help(key="scalar-const")
public class Const<T>
implements Scalar<T> {
    private static final long serialVersionUID = 1L;
    private final Scalar<T> operand;

    public Const(ArgQueue queue) throws PipeException {
        this((Scalar)queue.scalar((Type)Type.OBJECT).get());
    }

    public Const(Scalar<T> operand) throws PipeException {
        this.operand = operand;
    }

    public State newState(int flips) {
        return Level.asAggregation(this.operand).newState(flips);
    }

    public FullMerger newMerger() {
        return Level.asAggregation(this.operand).newMerger();
    }

    public InsertMerger newInsertMerger() {
        return Level.asAggregation(this.operand).newInsertMerger();
    }

    public Type<T> type() {
        return this.operand.type();
    }

    public Level level() {
        return Level.CONSTANT;
    }

    public T eval(Scope parent, Object obj) {
        return (T)Level.asScalar(this.operand).eval(parent, obj);
    }

    public long ttl() {
        return this.operand.ttl();
    }

    public long weight() {
        return this.operand.weight();
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.operand});
    }

    public String toString() {
        return "const(" + this.operand + ")";
    }

    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        return (T)Level.asAggregation(this.operand).eval(parent, tree, bounds);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.operand.visit(parent, visitor);
    }
}

