/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.Expression;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SeqEvaluable;
import net.intelie.pipes.State;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.model.WindowBoundsImpl;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.TransformIterable;

public class ExprSeqEvaluable
implements SeqEvaluable {
    private static final long serialVersionUID = 1L;
    private final boolean scalar;
    private final Type<?> type;
    private final Expression<?> expression;

    public ExprSeqEvaluable(Aggregation<?> expression) {
        this.expression = expression;
        this.scalar = Level.SCALAR.accepts(expression);
        this.type = this.scalar ? new SeqType(expression.type()) : expression.type();
    }

    public Object eval(Scope parent, Iterable input) {
        if (input == null) {
            return null;
        }
        if (this.scalar) {
            Scalar scalarExpr = Level.asScalar(this.expression);
            return new TransformIterable(parent, input, scalarExpr);
        }
        Aggregation aggregationExpr = Level.asAggregation(this.expression);
        State state = aggregationExpr.newState(0);
        for (Object obj : input) {
            state.yield(parent, obj);
        }
        return aggregationExpr.eval(parent, state.flip(), (WindowBounds)new WindowBoundsImpl(null, 0L, 1L, 0L, 1L, 1));
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.expression.visit(parent, visitor);
    }

    public boolean justMap() {
        return this.scalar;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return this.expression.toString();
    }
}

