/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.model.ArgumentModifier;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;

@Export(value={".fun"})
@Help(omit=true)
public class FunOperator
implements Scalar {
    private static final long serialVersionUID = 1L;
    private final ArgumentModifier modifier;
    private final Expression<Object> operand;

    public FunOperator(ArgQueue queue) throws PipeException {
        this.modifier = (ArgumentModifier)queue.get(ArgumentModifier.class);
        RowType finalType = this.modifier.decideType(queue.context().metadata().type());
        CompilerContext context = queue.context().newChildSource(queue.metadata().withType((Type)finalType));
        this.operand = (Expression)queue.withContext(context).expression((Type)Type.OBJECT).get();
    }

    public State newState(int flips) {
        return new MyState(Level.asAggregation(this.operand).newState(flips));
    }

    public FullMerger newMerger() {
        return Level.asAggregation(this.operand).newMerger();
    }

    public InsertMerger newInsertMerger() {
        return Level.asAggregation(this.operand).newInsertMerger();
    }

    public Type type() {
        return this.operand.type();
    }

    public Level level() {
        return this.operand.level();
    }

    public Object eval(Scope parent, Object obj) {
        return Level.asScalar(this.operand).eval(new Scope(parent, obj), (Object)this.modifier.modify(obj));
    }

    public long ttl() {
        return this.operand.ttl();
    }

    public long weight() {
        return this.operand.weight();
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.operand});
    }

    public String toString() {
        return "(fun " + this.modifier + ": " + this.operand + ")";
    }

    public Object eval(Scope parent, Tree tree, WindowBounds bounds) {
        return Level.asAggregation(this.operand).eval(parent, tree, bounds);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return PropertyVisitor.visitChildScope((Scope)parent, (PropertyVisitor)visitor, this.operand);
    }

    private class MyState
    implements State {
        private final State state;

        public MyState(State state) {
            this.state = state;
        }

        public void yield(Scope parent, Object obj) {
            this.state.yield(new Scope(parent, obj), (Object)FunOperator.this.modifier.modify(obj));
        }

        public Tree flip() {
            return this.state.flip();
        }
    }
}

