/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArgumentFlags;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.CallNode;
import net.intelie.pipes.ast.RawNode;
import net.intelie.pipes.types.Type;

@Help(omit=true)
@Export(value={".fnarg"})
public class FunctionArgument
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final AstNode defaultValue;
    private final ArgumentFlags flags;

    public FunctionArgument(ArgQueue queue) throws PipeException {
        this((String)queue.constantValue((Type)Type.STRING).get(), (AstNode)queue.getOptional(AstNode.class), new ArgumentFlags((String[])queue.constantValue((Type)Type.STRING).array()));
    }

    public FunctionArgument(String name, AstNode defaultValue, ArgumentFlags flags) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.flags = flags;
    }

    public static boolean isAnnotation(AstNode next) {
        return next instanceof CallNode && ((CallNode)next).getArgs().size() == 1 && ((CallNode)next).getName().startsWith("#");
    }

    public static Set<String> listAnnotations(AstNode node) {
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        while (FunctionArgument.isAnnotation(node)) {
            CallNode call = (CallNode)node;
            attributes.add(call.getName());
            node = (AstNode)call.getArgs().get(0);
        }
        return attributes;
    }

    public static AstNode filterAnnotations(AstNode next) {
        while (FunctionArgument.isAnnotation(next)) {
            next = (AstNode)((CallNode)next).getArgs().get(0);
        }
        return next;
    }

    public void process(ArgQueue queue, Map<String, AstNode> early, Map<String, AstNode> late) throws PipeException {
        AstNode node;
        if (early.containsKey(this.name) || late.containsKey(this.name)) {
            throw new PipeException("Repeated argument name: %s", new Object[]{this.name});
        }
        boolean argLate = this.flags.isLate();
        boolean hasNext = this.hasNext(queue);
        if (this.flags.isOptional() && !hasNext) {
            node = this.defaultValue;
            argLate = true;
        } else {
            if (this.flags.hasAnnotations() && !hasNext) {
                throw new PipeException("Required annotated argument '%s' not found. Expected annotations: %s", new Object[]{this.name, this.flags.getAnnotations()});
            }
            node = this.getValues(queue);
            if (node == null) {
                node = this.defaultValue;
                argLate = true;
            }
        }
        if (argLate) {
            late.put(this.name, node);
        } else {
            early.put(this.name, (AstNode)new RawNode(queue.context().compile(node)));
        }
    }

    public boolean isSuffix() {
        return this.flags.isSuffix();
    }

    private boolean hasNext(ArgQueue queue) {
        return queue.hasNext() && queue.getNextAnnotations().containsAll(this.flags.getAnnotations());
    }

    private AstNode getValues(ArgQueue queue) throws PipeException {
        if (this.flags.isVarargs()) {
            ArrayList<Object> nodes = new ArrayList<Object>();
            while (this.hasNext(queue)) {
                nodes.add(queue.get(AstNode.class));
            }
            return new CallNode(queue.location(), ".row", nodes);
        }
        if (this.flags.isOptional()) {
            return (AstNode)queue.getOptional(AstNode.class);
        }
        return (AstNode)queue.get(AstNode.class);
    }

    public String toString() {
        return this.flags.toString(this.name, this.defaultValue);
    }
}

