/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Export;
import net.intelie.pipes.Function;
import net.intelie.pipes.Help;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.model.FunctionSignature;

@Export(value={".fndef"})
@Help(omit=true)
public class FunctionDef
implements Function {
    private static final long serialVersionUID = 1L;
    private final FunctionSignature signature;
    private final AstNode localModule;
    private final AstNode body;

    public FunctionDef(ArgQueue queue) throws PipeException {
        this.signature = (FunctionSignature)queue.get(FunctionSignature.class);
        this.localModule = (AstNode)queue.get(AstNode.class);
        this.body = (AstNode)queue.get(AstNode.class);
    }

    public FunctionDef(FunctionSignature signature, AstNode body) {
        this.signature = signature;
        this.localModule = null;
        this.body = body;
    }

    public Object declare(ArgQueue queue) throws PipeException {
        try {
            CompilerContext context = queue.context().insideFunction(this.signature.makeContext(this, queue)).insideModule(this.signature.getModule());
            if (this.localModule != null) {
                context = context.addModule((Module)context.compile(this.localModule));
            }
            return context.compile(this.body);
        }
        catch (PipeException e) {
            throw e.maybeRemoveSource();
        }
    }

    public FunctionSignature signature() {
        return this.signature;
    }

    public String name() {
        return this.signature.name();
    }

    public String description() {
        return this.signature.description();
    }

    public HelpData help() {
        return this.signature.help();
    }
}

