/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.Function;
import net.intelie.pipes.Help;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.CallNode;
import net.intelie.pipes.ast.RawNode;
import net.intelie.pipes.model.FunctionDef;
import net.intelie.pipes.util.ExplodableList;

@Export(value={".fndefstar"})
@Help(omit=true)
public class FunctionDefStar
implements Function {
    private static final long serialVersionUID = 1L;
    private final FunctionDef function;

    public FunctionDefStar(ArgQueue queue) throws PipeException {
        this((FunctionDef)queue.get(FunctionDef.class));
    }

    public FunctionDefStar(FunctionDef function) throws PipeException {
        PipeException.check((!function.signature().isEmpty() ? 1 : 0) != 0, (Object)"def-star functions cannot have empty set of arguments");
        this.function = function;
    }

    public Object declare(ArgQueue queue) throws PipeException {
        ArrayList<Object> objs = new ArrayList<Object>();
        boolean anyNonExpression = false;
        int lastIndex = -1;
        while (queue.hasNext()) {
            Object obj = this.function.declare(queue);
            if (!(obj instanceof Expression)) {
                anyNonExpression = true;
            }
            objs.add(obj);
            PipeException.check((queue.index() != lastIndex ? 1 : 0) != 0, (Object)"Some expansion has consumed zero arguments. This is not allowed.");
            lastIndex = queue.index();
        }
        if (anyNonExpression) {
            return new ExplodableList(objs);
        }
        List nodes = objs.stream().map(RawNode::new).collect(Collectors.toList());
        return queue.compiler().compile((AstNode)new CallNode(queue.location(), ".row", nodes));
    }

    public String name() {
        return this.function.name();
    }

    public String description() {
        return this.function.signature().description(true);
    }

    public HelpData help() {
        return this.function.signature().help(true);
    }
}

