/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Function;
import net.intelie.pipes.FunctionContext;
import net.intelie.pipes.HasHelp;
import net.intelie.pipes.Help;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.ModuleContext;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.guava.base.Strings;
import net.intelie.pipes.model.FunctionArgument;
import net.intelie.pipes.types.Metadata;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

@Export(value={".fnsig"})
@Help(omit=true)
public class FunctionSignature
implements HasHelp,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ModuleContext module;
    private final String name;
    private final String description;
    private final FunctionArgument[] arguments;
    private final FunctionContext closureContext;

    public FunctionSignature(ArgQueue queue) throws PipeException {
        this(queue.context().moduleContext(), queue.context().functionContext(), (String)queue.constantValue((Type)Type.STRING).get(), Type.STRING.cast(queue.constantValue((Type)Type.OBJECT).getSafe()), (FunctionArgument[])queue.array(FunctionArgument.class));
    }

    public FunctionSignature(String name, FunctionArgument ... arguments) {
        this(new ModuleContext(), new FunctionContext(Metadata.RAW), name, null, arguments);
    }

    public FunctionSignature(ModuleContext module, FunctionContext closureContext, String name, String description, FunctionArgument ... arguments) {
        this.module = module;
        this.name = module.resolveName(name);
        this.description = description;
        this.arguments = arguments;
        this.closureContext = closureContext;
    }

    public ModuleContext getModule() {
        return this.module;
    }

    public FunctionContext makeContext(Function function, ArgQueue queue) throws PipeException {
        LinkedHashMap<String, AstNode> early = new LinkedHashMap<String, AstNode>();
        LinkedHashMap<String, AstNode> late = new LinkedHashMap<String, AstNode>();
        for (FunctionArgument arg : this.arguments) {
            arg.process(queue, early, late);
        }
        return this.closureContext.makeClosure(function, early, late);
    }

    public String name() {
        return this.name;
    }

    public HelpData help() {
        return this.help(false);
    }

    public String description() {
        return this.description(false);
    }

    public String description(boolean star) {
        return this.module.augmentDescription(this.name + "(" + Iterables.join((String)", ", (Object[])Arrays.stream(this.arguments).filter(x -> !x.isSuffix()).toArray()) + Iterables.join((String)"", (Object[])Arrays.stream(this.arguments).filter(FunctionArgument::isSuffix).map(x -> " " + x).toArray()) + (star ? ", ..." : "") + ")");
    }

    public HelpData help(boolean star) {
        boolean macro = this.name.startsWith("@@");
        boolean pipe = !macro && this.name.startsWith("@");
        StringBuilder usage = new StringBuilder();
        usage.append(this.name);
        if (!macro) {
            usage.append(pipe ? (char)' ' : '(');
            this.appendArgs(usage, false);
            this.appendArgs(usage, true);
            if (star) {
                usage.append(", ...");
            }
            if (!pipe) {
                if (star) {
                    usage.append(") \u2192 <row(?)>");
                } else {
                    usage.append(") \u2192 <?>");
                }
            }
        }
        return new HelpData(macro ? "macro" : (pipe ? "pipe" : "function"), this.name, usage.toString(), this.description, this.makeSince(), null, this.module.getUrl(), null);
    }

    private void appendArgs(StringBuilder usage, boolean suffix) {
        boolean first = true;
        for (FunctionArgument argument : this.arguments) {
            if (argument.isSuffix() != suffix) continue;
            if (suffix) {
                usage.append(' ');
            } else if (!first) {
                usage.append(", ");
            }
            usage.append('<').append(argument).append('>');
            first = false;
        }
    }

    private String makeSince() {
        if (Strings.isNullOrEmpty(this.module.getDisplayName())) {
            return "$from this query";
        }
        return "$from module '" + this.module.getDisplayName() + "'";
    }

    public boolean isEmpty() {
        return this.arguments.length == 0;
    }
}

