/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.UnsafeRow;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.modules.FallbackToSelect;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Preconditions;
import net.intelie.pipes.util.UpdateHeap;

@Export(value={".by"})
@Help(omit=true)
public class GroupByImpl
implements GroupBy {
    private static final long serialVersionUID = 1L;
    public static final String ENSURE_EXPIRY_MESSAGE = "Expression requires non-empty 'by' clause to have an explicit expiry policy. Add 'expiry <period>' after the by clause. If you wish groups never expire, use 'expiry null'.";
    private final SelectClause select;
    private final Period expiry;
    private final Property<Double> timestamp;
    private final Boolean hasExpiry;

    public GroupByImpl(ArgQueue queue) throws PipeException {
        this.select = (SelectClause)queue.scalar((Type)Type.ROW).getSafe(SelectClause.class, (Fallback)new FallbackToSelect(""));
        boolean hasExpiry = (Boolean)queue.constantValue((Type)Type.BOOLEAN).getSafe(x -> false);
        this.expiry = (Period)queue.constantValue((Type)Type.PERIOD).getOptional();
        this.timestamp = this.expiry != null ? queue.context().timestamp() : null;
        this.hasExpiry = hasExpiry || this.expiry != null;
    }

    public int size() {
        return this.select.size();
    }

    public void validate(ValidationContext context) throws PipeException {
        this.select.validate(context);
    }

    public ClauseInfo info() {
        return this.select.info();
    }

    public Row eval(Scope parent, Object obj) {
        return (Row)this.select.eval(parent, obj);
    }

    public Type<Row> type() {
        return this.select.type();
    }

    public void evalUnsafe(Scope parent, Object obj, UnsafeRow row) {
        this.select.evalUnsafe(parent, obj, row);
    }

    public void evalUnsafe(Scope parent, Object obj, UnsafeRow row, int index) {
        this.select.evalUnsafe(parent, obj, row, index);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        if (this.timestamp != null) {
            this.timestamp.visit(parent, visitor);
        }
        return this.select.visit(parent, visitor);
    }

    public GroupBy ensureNoExpiry() throws PipeException {
        PipeException.check((this.hasExpiry == false ? 1 : 0) != 0, (String)"Expression requires 'by' clause to have no expiry. Found: %s", (Object[])new Object[]{this.expiry});
        return this;
    }

    public GroupBy ensureExpiry() throws PipeException {
        PipeException.check((this.size() == 0 || this.hasExpiry != false ? 1 : 0) != 0, (Object)ENSURE_EXPIRY_MESSAGE);
        return this;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public <T> GroupBy.State<T> newState(GroupBy.Init<T> initializer) {
        if (this.size() == 0) {
            return new EmptyState<T>(initializer);
        }
        return new MultiState<T>(initializer);
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.select.size() > 0) {
            list.add("by " + this.select);
        }
        if (this.hasExpiry.booleanValue()) {
            list.add("expiry " + this.expiry);
        }
        return Iterables.join((String)" ", list);
    }

    private class MultiState<T>
    implements GroupBy.State<T> {
        private static final long serialVersionUID = 1L;
        private final Map<UnsafeRow, Slot> slots = new LinkedHashMap<UnsafeRow, Slot>();
        private final GroupBy.Init<T> initializer;
        private final UnsafeRow buffer = new UnsafeRow(GroupByImpl.access$400(GroupByImpl.this).size());
        private final UpdateHeap<Slot> heap = new UpdateHeap();
        private Long lastTimestamp = null;

        public MultiState(GroupBy.Init<T> initializer) {
            this.initializer = initializer;
        }

        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private final Iterator<Slot> it;
                private Slot last;
                {
                    this.it = MultiState.this.slots.values().iterator();
                    this.last = null;
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public T next() {
                    this.last = this.it.next();
                    return this.last.state;
                }

                @Override
                public void remove() {
                    Preconditions.checkState((this.last != null ? 1 : 0) != 0, (Object)"Must call next() before removing");
                    MultiState.this.heap.remove(this.last);
                    this.it.remove();
                }
            };
        }

        public T emptyState() {
            throw new UnsupportedOperationException("there is no empty state here");
        }

        public void offerTimestamp(long timestamp) {
            this.lastTimestamp = this.lastTimestamp == null ? Long.valueOf(timestamp) : Long.valueOf(Math.max(this.lastTimestamp, timestamp));
            while (!this.heap.isEmpty() && this.heap.top().touch < this.lastTimestamp) {
                Slot top = this.heap.top();
                this.heap.remove(top);
                this.slots.remove(top.key);
            }
        }

        public T get(Scope parent, Object obj) {
            Double evalTimestamp;
            if (GroupByImpl.this.timestamp != null && (evalTimestamp = (Double)GroupByImpl.this.timestamp.eval(parent, obj)) != null) {
                this.offerTimestamp(evalTimestamp.longValue());
            }
            GroupByImpl.this.select.evalUnsafe(parent, obj, this.buffer);
            Slot slot = this.slots.get(this.buffer);
            if (slot == null) {
                UnsafeRow copy = this.buffer.copy();
                slot = new Slot(copy);
                this.slots.put(copy, slot);
            }
            if (this.lastTimestamp != null) {
                slot.touch = GroupByImpl.this.expiry.add(this.lastTimestamp.longValue());
            }
            this.heap.addOrUpdate(slot);
            return (T)slot.state;
        }

        private class Slot
        implements Comparable<Slot> {
            private final T state;
            private final UnsafeRow key;
            private Long touch = null;

            private Slot(UnsafeRow key) {
                this.key = key;
                this.state = MultiState.this.initializer.init(key);
            }

            @Override
            public int compareTo(Slot that) {
                if (this.touch == null || that.touch == null) {
                    return this.touch == null ? (that.touch == null ? 0 : -1) : 1;
                }
                return Long.compare(this.touch, that.touch);
            }
        }
    }

    private class EmptyState<T>
    implements GroupBy.State<T> {
        private static final long serialVersionUID = 1L;
        private final UnsafeRow EMPTY_ROW = new UnsafeRow(0);
        private final GroupBy.Init<T> initializer;
        private T state;
        private Long touch;
        private Long lastTimestamp = null;

        public EmptyState(GroupBy.Init<T> initializer) {
            this.initializer = initializer;
            this.state = initializer.init(this.EMPTY_ROW);
        }

        public void offerTimestamp(long timestamp) {
            this.lastTimestamp = this.lastTimestamp == null ? Long.valueOf(timestamp) : Long.valueOf(Math.max(this.lastTimestamp, timestamp));
            if (this.touch != null && this.touch < this.lastTimestamp) {
                this.reset();
            }
        }

        private void reset() {
            this.state = this.initializer.init(this.EMPTY_ROW);
            this.touch = null;
        }

        public T emptyState() {
            return this.state;
        }

        public T get(Scope parent, Object obj) {
            Double evalTimestamp;
            if (GroupByImpl.this.timestamp != null && (evalTimestamp = (Double)GroupByImpl.this.timestamp.eval(parent, obj)) != null) {
                this.offerTimestamp(evalTimestamp.longValue());
            }
            if (this.lastTimestamp != null) {
                this.touch = GroupByImpl.this.expiry.add(this.lastTimestamp.longValue());
            }
            return this.state;
        }

        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private boolean consumed = false;

                @Override
                public boolean hasNext() {
                    return !this.consumed;
                }

                @Override
                public T next() {
                    Preconditions.checkState((!this.consumed ? 1 : 0) != 0);
                    this.consumed = true;
                    return EmptyState.this.state;
                }

                @Override
                public void remove() {
                    Preconditions.checkState((boolean)this.consumed);
                    EmptyState.this.reset();
                }
            };
        }
    }
}

