/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.LinkedHashMap;
import java.util.Map;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.Row;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.SelectInsertMerger;
import net.intelie.pipes.Tree;
import net.intelie.pipes.model.GroupingMultiTree;

public class GroupingInsertMerger
extends InsertMerger.Base<GroupingTree> {
    public static final ArrayRow EMPTY_ROW = new ArrayRow(new Object[0]);
    private final SelectClause select;
    private final boolean hasGroup;
    private final Map<Row, SingleMerger> state = new LinkedHashMap<Row, SingleMerger>();

    public GroupingInsertMerger(SelectClause select, boolean hasGroup) {
        this.select = select;
        this.hasGroup = hasGroup;
        if (!hasGroup) {
            this.state.put((Row)EMPTY_ROW, new SingleMerger());
        }
    }

    public void pushQ(GroupingTree tree) {
        for (Map.Entry entry : tree.entries()) {
            SingleMerger merger = this.state.computeIfAbsent((Row)entry.getKey(), k -> new SingleMerger());
            merger.add((Tree)entry.getValue());
        }
    }

    public void clear() {
        this.state.clear();
        if (!this.hasGroup) {
            this.state.put((Row)EMPTY_ROW, new SingleMerger());
        }
    }

    public GroupingTree get() {
        LinkedHashMap<Row, GroupingTree> rows = new LinkedHashMap<Row, GroupingTree>();
        for (Map.Entry<Row, SingleMerger> entry : this.state.entrySet()) {
            rows.put(entry.getKey(), entry.getValue().get());
        }
        if (rows.size() == 1 && rows.containsKey(EMPTY_ROW)) {
            return (GroupingTree)rows.get(EMPTY_ROW);
        }
        return new GroupingMultiTree(rows);
    }

    private class SingleMerger {
        private final SelectInsertMerger merger;
        private int size;

        private SingleMerger() {
            this.merger = GroupingInsertMerger.this.select.newInsertMerger();
            this.size = 0;
        }

        public void add(Tree tree) {
            ++this.size;
            this.merger.push(tree);
        }

        public GroupingTree get() {
            return this.merger.get();
        }
    }
}

