/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.LinkedHashMap;
import java.util.Map;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.Row;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.SelectMerger;
import net.intelie.pipes.Tree;
import net.intelie.pipes.model.GroupingMultiTree;

public class GroupingMerger
extends FullMerger.Queued<GroupingTree> {
    public static final ArrayRow EMPTY_ROW = new ArrayRow(new Object[0]);
    private final SelectClause select;
    private final boolean hasGroup;
    private final Map<Row, SingleMerger> state = new LinkedHashMap<Row, SingleMerger>();

    public GroupingMerger(SelectClause select, boolean hasGroup) {
        this.select = select;
        this.hasGroup = hasGroup;
        if (!hasGroup) {
            this.state.put((Row)EMPTY_ROW, new SingleMerger());
        }
    }

    public void pushQ(GroupingTree tree) {
        for (Map.Entry entry : tree.entries()) {
            SingleMerger merger = this.state.computeIfAbsent((Row)entry.getKey(), k -> new SingleMerger());
            merger.add((Tree)entry.getValue());
        }
    }

    public void popQ(GroupingTree tree) {
        for (Map.Entry entry : tree.entries()) {
            SingleMerger merger = this.state.get(entry.getKey());
            if (merger == null || merger.remove((Tree)entry.getValue()) || !this.hasGroup) continue;
            this.state.remove(entry.getKey());
        }
    }

    public void clearQ() {
        this.state.clear();
        if (!this.hasGroup) {
            this.state.put((Row)EMPTY_ROW, new SingleMerger());
        }
    }

    public GroupingTree get() {
        LinkedHashMap<Row, GroupingTree> rows = new LinkedHashMap<Row, GroupingTree>();
        for (Map.Entry<Row, SingleMerger> entry : this.state.entrySet()) {
            rows.put(entry.getKey(), entry.getValue().get());
        }
        if (rows.size() == 1 && rows.containsKey(EMPTY_ROW)) {
            return (GroupingTree)rows.get(EMPTY_ROW);
        }
        return new GroupingMultiTree(rows);
    }

    private class SingleMerger {
        private final SelectMerger merger;
        private int size;

        private SingleMerger() {
            this.merger = GroupingMerger.this.select.newMerger();
            this.size = 0;
        }

        public void add(Tree tree) {
            ++this.size;
            this.merger.push(tree);
        }

        public boolean remove(Tree tree) {
            this.merger.pop();
            return --this.size > 0;
        }

        public GroupingTree get() {
            return this.merger.get();
        }
    }
}

