/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.Map;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.Tree;
import net.intelie.pipes.WindowBounds;

public class GroupingMultiTree
implements GroupingTree {
    private static final long serialVersionUID = 1L;
    private final Map<Row, GroupingTree> map;

    public GroupingMultiTree(Map<Row, GroupingTree> map) {
        this.map = map;
    }

    public Iterable<Map.Entry<Row, GroupingTree>> entries() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public ArrayRowList toRowList(Scope parent, SelectClause select, WindowBounds bounds, ArrayRow first) {
        ArrayRow[] rows = new ArrayRow[this.size()];
        int i = 0;
        for (Map.Entry<Row, GroupingTree> entry : this.entries()) {
            Row row = (Row)select.eval(parent, (Tree)entry.getValue(), bounds);
            Row key = entry.getKey();
            rows[i++] = ArrayRow.concat((Row[])new Row[]{first, key, row});
        }
        return new ArrayRowList((Row[])rows);
    }
}

