/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.Iterator;
import java.util.LinkedHashMap;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.SelectState;
import net.intelie.pipes.State;
import net.intelie.pipes.UnsafeRow;
import net.intelie.pipes.model.GroupingMultiTree;

public class GroupingState
implements State {
    private final GroupBy group;
    private final GroupBy.State<InnerState> state;
    private final long ttl;
    private int flips;

    public GroupingState(int flips, GroupBy group, SelectClause select) {
        this.flips = flips;
        this.ttl = select.ttl();
        this.state = group.newState(key -> new InnerState(key, select.newState(this.flips)));
        this.group = group;
    }

    public void yield(Scope parent, Object obj) {
        InnerState inner = (InnerState)this.state.get(parent, obj);
        inner.refreshTTL(this.ttl);
        inner.yield(parent, obj);
    }

    public GroupingTree flip() {
        ++this.flips;
        if (this.group.size() == 0) {
            return ((InnerState)this.state.emptyState()).flip();
        }
        LinkedHashMap<Row, GroupingTree> map = new LinkedHashMap<Row, GroupingTree>();
        Iterator it = this.state.iterator();
        while (it.hasNext()) {
            InnerState entry = (InnerState)it.next();
            long valueTtl = entry.decreaseTTL();
            if (valueTtl >= 0L || this.group.size() == 0 || this.ttl == Long.MAX_VALUE) {
                map.put((Row)entry.key().toRow(), entry.flip());
                continue;
            }
            it.remove();
        }
        return new GroupingMultiTree(map);
    }

    private static class InnerState
    implements State {
        private final UnsafeRow key;
        private final SelectState selected;
        private long ttl = 0L;

        private InnerState(UnsafeRow key, SelectState selected) {
            this.key = key;
            this.selected = selected;
        }

        public UnsafeRow key() {
            return this.key;
        }

        public void refreshTTL(long value) {
            this.ttl = value;
        }

        public long decreaseTTL() {
            return --this.ttl;
        }

        public void yield(Scope parent, Object obj) {
            this.selected.yield(parent, obj);
        }

        public GroupingTree flip() {
            return this.selected.flip();
        }
    }
}

