/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.Collections;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.Explodable;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.GroupBy;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.model.GroupingInsertMerger;
import net.intelie.pipes.model.GroupingMerger;
import net.intelie.pipes.model.GroupingState;
import net.intelie.pipes.model.SelectClauseImpl;
import net.intelie.pipes.modules.FallbackToConstant;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

@Export(value={".row"})
@Help(omit=true)
public class MakeRowFunction
implements Scalar,
Explodable {
    private static final long serialVersionUID = 1L;
    private final GroupBy group;
    private final SelectClause select;
    private final Type type;
    private final Level level;
    private final boolean hasGroup;

    public MakeRowFunction(ArgQueue queue) throws PipeException {
        this.group = (GroupBy)queue.getSafe(GroupBy.class, new FallbackToConstant<GroupBy>(GroupBy.NONE));
        this.select = new SelectClauseImpl(queue);
        this.type = this.makeType(this.group, this.select);
        this.hasGroup = this.group.size() > 0;
        this.level = Level.min((Level[])new Level[]{this.select.realLevel(), this.hasGroup ? Level.AGGREGATION : Level.CONSTANT});
    }

    private Type makeType(GroupBy group, SelectClause select) {
        if (group.size() > 0) {
            return new SeqType((Type)new RowType(new RowFields(new ClauseInfo(new FieldInfo[0]), group.info(), select.info())));
        }
        return new RowType(new RowFields(new ClauseInfo(new FieldInfo[0]), new ClauseInfo(new FieldInfo[0]), select.info()));
    }

    public State newState(int flips) {
        if (this.hasGroup) {
            return new GroupingState(flips, this.group, this.select);
        }
        return this.select.newState(flips);
    }

    public FullMerger newMerger() {
        if (this.hasGroup) {
            return new GroupingMerger(this.select, true);
        }
        return this.select.newMerger();
    }

    public InsertMerger newInsertMerger() {
        if (this.hasGroup) {
            return new GroupingInsertMerger(this.select, true);
        }
        return this.select.newInsertMerger();
    }

    public Object eval(Scope parent, Tree tree, WindowBounds bounds) {
        if (this.hasGroup) {
            GroupingTree myTree = (GroupingTree)tree;
            return myTree.toRowList(parent, this.select, bounds, new ArrayRow(new Object[0]));
        }
        return this.select.eval(parent, tree, bounds);
    }

    public Row eval(Scope parent, Object obj) {
        return (Row)this.select.eval(parent, obj);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        this.group.visit(parent, visitor);
        return this.select.visit(parent, visitor);
    }

    public Level level() {
        return this.level;
    }

    public long ttl() {
        return this.select.ttl();
    }

    public long weight() {
        return ((long)(this.group.size() * 32) + this.select.weight()) * (long)(!this.group.isEmpty() ? 64 : 1);
    }

    public void validate(ValidationContext context) throws PipeException {
        context.defer(new Expression[]{this.select});
        this.group.validate(context);
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        String suffix = this.hasGroup ? (this.select.size() > 0 ? " " : "") + this.group : (this.select.size() == 1 ? "," : "");
        return "(" + this.select.toString() + suffix + ")";
    }

    public Iterable<?> explode() throws PipeException {
        if (this.group.isEmpty()) {
            return this.select.explode();
        }
        return Collections.singletonList(this);
    }
}

