/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.ArrayList;
import java.util.Locale;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.CompilerContext;
import net.intelie.pipes.Function;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.Module;
import net.intelie.pipes.PipeCompiler;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.CallNode;
import net.intelie.pipes.ast.SourceLocation;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.LiteralRepresentation;

public class ModuleAssertFunction
implements Function {
    private static final long serialVersionUID = 1L;

    public Object declare(ArgQueue queue) throws PipeException {
        Module module = (Module)queue.get(Module.class);
        CompilerContext context = queue.context().addModule(module);
        PipeCompiler compiler = queue.withContext(context).compiler().expression();
        AstNode[] assertions = (AstNode[])queue.array(AstNode.class);
        SourceLocation location = queue.location();
        String message = null;
        int failed = 0;
        for (AstNode node : assertions) {
            Scalar scalar = (Scalar)compiler.compileToQueue(new AstNode[]{node}).scalar((Type)Type.BOOLEAN).get();
            if (Boolean.TRUE.equals(scalar.eval(null, null))) continue;
            ++failed;
            if (message != null) continue;
            message = String.format((Locale)null, "Assertion failed: %s", ModuleAssertFunction.makeAssertion((PipeCompiler<Object>)compiler, node));
            SourceLocation candidate = SourceLocation.maybeGetFrom((AstNode)node);
            if (candidate == null) continue;
            location = candidate;
        }
        if (failed > 0) {
            throw new PipeException((Object)(message + (failed > 1 ? String.format((Locale)null, " (%d more)", failed - 1) : ""))).maybeAddSource(location);
        }
        return module;
    }

    public static String makeAssertion(PipeCompiler<Object> compiler, AstNode node) throws PipeException {
        if (node instanceof CallNode) {
            ArrayList<String> args = new ArrayList<String>();
            CallNode call = (CallNode)node;
            for (AstNode child : call.getArgs()) {
                Scalar constant = (Scalar)compiler.compileToQueue(new AstNode[]{child}).scalar((Type)Type.OBJECT).get();
                Object obj = constant.eval(null, null);
                args.add(LiteralRepresentation.toString((Type)constant.type(), (Object)obj));
            }
            return call.getName() + "(" + Iterables.join((String)", ", args) + ")";
        }
        return String.valueOf(node);
    }

    public String name() {
        return ".moduleAssert";
    }

    public String description() {
        return "<module>";
    }

    public HelpData help() {
        return null;
    }
}

