/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Explodable;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.NamedExpression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.UnsafeRow;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.model.PropertyAccess;
import net.intelie.pipes.modules.FallbackToConstant;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Escapes;

@Export(value={".namedfield"})
@Help(omit=true)
public class NamedExpressionImpl
implements Scalar,
NamedExpression {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Expression<?> expr;
    private final String originalName;
    private final boolean expand;
    private final int size;
    private final int first;
    private final int last;
    private final RowFields fields;

    public NamedExpressionImpl(ArgQueue queue) throws PipeException {
        this((Expression)queue.expression((Type)Type.OBJECT).get(), (String)queue.constantValue((Type)Type.STRING).getOptional(new FallbackToConstant<Object>(null)), (Boolean)queue.constantValue((Type)Type.BOOLEAN).getOptional(new FallbackToConstant<Boolean>(false)));
    }

    public NamedExpressionImpl(Expression<?> expression) throws PipeException {
        this(expression, null);
    }

    public NamedExpressionImpl(Expression<?> expression, String name) throws PipeException {
        this(expression, name, false);
    }

    public NamedExpressionImpl(Expression<?> expression, String name, boolean expand) throws PipeException {
        this.originalName = name;
        this.expand = expand;
        this.name = name == null ? NamedExpressionImpl.makeName(expression) : name;
        this.expr = expression;
        this.fields = RowType.getFields((Type)expression.type());
        if (expand && this.fields != null) {
            this.first = this.fields.timestamp().size();
            this.last = this.fields.size();
            this.size = this.last - this.first;
        } else {
            this.last = 0;
            this.first = 0;
            this.size = 1;
        }
    }

    public static String makeName(Object obj) {
        if (obj instanceof PropertyAccess) {
            return ((PropertyAccess)obj).effectiveName();
        }
        return Escapes.safeIdentifier((String)("" + obj));
    }

    public NamedExpressionImpl makeExpanded() throws PipeException {
        return new NamedExpressionImpl(this.expr, this.originalName, true);
    }

    public boolean autonamed() {
        return this.originalName == null;
    }

    public int size() {
        return this.size;
    }

    public boolean expand() {
        return this.expand;
    }

    public void validate(ValidationContext context) throws PipeException {
        this.validateExpansionOfRawTypes();
        context.defer(new Expression[]{this.expr});
    }

    public void validateExpansionOfRawTypes() throws PipeException {
        if (this.expand && this.fields == null) {
            throw new PipeException("Expansion of raw-valued types is not allowed: <%s>", new Object[]{this.expr});
        }
    }

    public String nameFor(String field) {
        if (this.originalName == null) {
            return field;
        }
        return this.originalName.replace("*", field);
    }

    public State newState(int flips) {
        return Level.asAggregation(this.expr).newState(flips);
    }

    public FullMerger newMerger() {
        return Level.asAggregation(this.expr).newMerger();
    }

    public InsertMerger newInsertMerger() {
        return Level.asAggregation(this.expr).newInsertMerger();
    }

    public Object eval(Scope parent, Object obj) {
        return Level.asScalar(this.expr).eval(parent, obj);
    }

    public Object eval(Scope parent, Tree tree, WindowBounds bounds) {
        return Level.asAggregation(this.expr).eval(parent, tree, bounds);
    }

    public int evalUnsafe(Scope parent, Tree obj, WindowBounds bounds, UnsafeRow row, int i) {
        Object eval = this.eval(parent, obj, bounds);
        return this.evalSingle(row, i, eval);
    }

    public int evalUnsafe(Scope parent, Object obj, UnsafeRow row, int i) {
        Object eval = this.eval(parent, obj);
        return this.evalSingle(row, i, eval);
    }

    private int evalSingle(UnsafeRow row, int i, Object eval) {
        if (this.expand) {
            Row evalRow = eval instanceof Row ? (Row)eval : null;
            for (int j = this.first; j < this.last; ++j) {
                row.set(i++, evalRow != null ? evalRow.get(j) : null);
            }
        } else {
            row.set(i++, eval);
        }
        return i;
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.expr.visit(parent, visitor);
    }

    public String originalName() {
        return this.originalName;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.expr.type();
    }

    public Expression expr() {
        return this.expr;
    }

    public Level level() {
        return Level.min((Level[])new Level[]{Level.SCALAR, this.expr.level()});
    }

    public long ttl() {
        return this.expr.ttl();
    }

    public long weight() {
        return this.expr.weight();
    }

    public Iterable<?> explode() throws PipeException {
        if (this.expr instanceof Explodable) {
            return ((Explodable)this.expr).explode();
        }
        return Collections.singletonList(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.expand) {
            builder.append("expand ");
        }
        builder.append(this.expr);
        if (this.originalName != null) {
            builder.append(" as ").append(Escapes.formatIdentifier((String)this.originalName));
        }
        return builder.toString();
    }

    public List<FieldInfo> info() {
        if (this.expand) {
            ArrayList<FieldInfo> list = new ArrayList<FieldInfo>();
            for (FieldInfo info : this.fields.group()) {
                list.add(new FieldInfo(this.nameFor(info.name()), info.type()));
            }
            for (FieldInfo info : this.fields.select()) {
                list.add(new FieldInfo(this.nameFor(info.name()), info.type()));
            }
            return list;
        }
        return Collections.singletonList(new FieldInfo(this.name, this.expr.type()));
    }
}

