/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Function;
import net.intelie.pipes.HelpData;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.SimplePeriod;
import net.intelie.pipes.types.BatchOutput;
import net.intelie.pipes.types.ItemOutput;
import net.intelie.pipes.types.TimeOutput;
import net.intelie.pipes.types.TotalOutput;
import net.intelie.pipes.types.Type;

public class OutputFunction
implements Function {
    private static final long serialVersionUID = 1L;

    public Object declare(ArgQueue queue) throws PipeException {
        int amount;
        String unit = (String)queue.constantValue((Type)Type.STRING).get();
        if (this.isUnit(unit, "end")) {
            return new TotalOutput();
        }
        if (this.isUnit(unit, "before")) {
            Aggregation aggregation = (Aggregation)queue.aggregation((Type)Type.BOOLEAN).get();
            return new ItemOutput(false, aggregation);
        }
        if (this.isUnit(unit, "after")) {
            Aggregation aggregation = (Aggregation)queue.aggregation((Type)Type.BOOLEAN).get();
            return new ItemOutput(true, aggregation);
        }
        if (this.isUnit(unit, "expr")) {
            Aggregation aggregation = (Aggregation)queue.aggregation((Type)Type.BOOLEAN).getSafe();
            if (aggregation != null) {
                return new ItemOutput(true, aggregation);
            }
            Period period = (Period)queue.constantValue((Type)Type.PERIOD).getSafe();
            if (period != null) {
                return new TimeOutput(period);
            }
            throw new PipeException("Unknown output expression type: %s", new Object[]{queue.getSafe()});
        }
        Double amountObj = (Double)queue.constantValue((Type)Type.NUMBER).getSafe();
        int n = amount = amountObj != null ? amountObj.intValue() : 1;
        if (this.isUnit(unit, "item", "items")) {
            return new ItemOutput(amount);
        }
        if (this.isUnit(unit, "batch", "batchs", "batches")) {
            return new BatchOutput(amount);
        }
        return new TimeOutput((Period)new SimplePeriod(amount, unit));
    }

    private boolean isUnit(String unit, String ... expected) {
        for (String s : expected) {
            if (!s.equalsIgnoreCase(unit)) continue;
            return true;
        }
        return false;
    }

    public String description() {
        return "<output>";
    }

    public String name() {
        return ".output";
    }

    public HelpData help() {
        return null;
    }
}

