/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.ArrayList;
import net.intelie.pipes.AnyExpr;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Export;
import net.intelie.pipes.Expression;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertySource;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.filters.ObjectSink;
import net.intelie.pipes.guava.collect.Lists;
import net.intelie.pipes.modules.FallbackToConstant;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Escapes;
import net.intelie.pipes.util.Iterables;

@Export(value={".property"})
@Help(omit=true)
public class PropertyAccess
implements Scalar,
Property {
    private static final long serialVersionUID = 1L;
    private final Expression<?> target;
    private final boolean hasArgs;
    private final Property<?> property;

    public PropertyAccess(ArgQueue queue) throws PipeException {
        this((PropertySource)queue.context(), (Expression)queue.expression((Type)Type.OBJECT).getOptional(), (String)queue.constantValue((Type)Type.STRING).getOptional(), (Boolean)queue.constantValue((Type)Type.BOOLEAN).getOptional(new FallbackToConstant<Boolean>(false)), (Scalar[])queue.scalar((Type)Type.OBJECT).array());
    }

    private PropertyAccess(PropertySource source, Expression<?> target, String name, boolean hasArgs, Scalar ... args) throws PipeException {
        this(target, hasArgs, PropertyAccess.makeProperty(source, target, name, hasArgs, args));
    }

    private PropertyAccess(Expression<?> target, boolean hasArgs, Property<?> property) throws PipeException {
        this.target = target;
        this.hasArgs = hasArgs;
        this.property = property;
    }

    private static Property<?> makeProperty(PropertySource source, Expression<?> target, String name, boolean hasArgs, Scalar ... args) throws PipeException {
        Property property;
        source = target == null ? source : source.newSource(source.metadata().withType(target.type()));
        Property property2 = property = name != null ? source.property(name) : source.property();
        if (hasArgs) {
            property = property.indexed(args);
        }
        return property;
    }

    public PropertyAccess hint(Type hint) throws PipeException {
        return new PropertyAccess(this.target, this.hasArgs, this.property.hint(hint));
    }

    public PropertyAccess indexed(Scalar ... args) throws PipeException {
        return new PropertyAccess(this.target, true, this.property.indexed(args));
    }

    public void evalRaw(Scope parent, Object obj, ObjectSink sink) {
        this.property.evalRaw(parent, obj, sink);
    }

    public boolean sameProperty(Property other) {
        if (other instanceof PropertyAccess) {
            return this.sameProperty(((PropertyAccess)other).property);
        }
        return this.property.sameProperty(other);
    }

    public Object eval(Scope parent, Object obj) {
        if (this.target != null) {
            obj = Level.asScalar(this.target).eval(parent, obj);
        }
        return this.property.eval(parent, obj);
    }

    public String name() {
        return this.property.name();
    }

    public Iterable<Scalar> args() {
        return this.property.args();
    }

    public Property impl() {
        return this.property;
    }

    public Type type() {
        return this.property.type();
    }

    public boolean requiresObjectFix() {
        return this.property.requiresObjectFix();
    }

    public Level level() {
        return this.target != null ? this.target.level() : Level.SCALAR;
    }

    public void validate(ValidationContext context) throws PipeException {
        if (this.target != null) {
            context.defer(new Expression[]{this.target});
        }
        context.defer(this.property.args());
    }

    public State newState(int flips) {
        if (this.target == null) {
            return new AnyExpr.AnyState((Scalar)this);
        }
        return Level.asAggregation(this.target).newState(flips);
    }

    public FullMerger newMerger() {
        if (this.target == null) {
            return new AnyExpr.AnyMerger();
        }
        return Level.asAggregation(this.target).newMerger();
    }

    public InsertMerger newInsertMerger() {
        if (this.target == null) {
            return new AnyExpr.AnyMerger();
        }
        return Level.asAggregation(this.target).newInsertMerger();
    }

    public String toString() {
        return this.renderTarget() + this.renderName() + this.renderArgs();
    }

    private String renderTarget() {
        if (this.target == null) {
            return "";
        }
        return this.target + "->";
    }

    public long ttl() {
        return 1L;
    }

    private String renderArgs() {
        ArrayList args = Lists.newArrayList(this.property.args());
        return this.hasArgs ? "[" + Iterables.join((String)", ", args) + "]" : "";
    }

    private String renderName() {
        return Escapes.formatIdentifier((String)this.name());
    }

    public Object eval(Scope parent, Tree tree, WindowBounds bounds) {
        if (this.target == null) {
            return AnyExpr.evalTree((Tree)tree);
        }
        return this.property.eval(parent, Level.asAggregation(this.target).eval(parent, tree, bounds));
    }

    public long weight() {
        return this.target != null ? this.target.weight() : 40L;
    }

    public String effectiveName() {
        return this.name();
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        if (this.target != null) {
            visitor = this.target.visit(parent, visitor);
        }
        return this.property.visit(parent, visitor);
    }
}

