/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.ArrayRowList;
import net.intelie.pipes.Export;
import net.intelie.pipes.Fallback;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.GroupingTree;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.NamedExpression;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Row;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SelectClause;
import net.intelie.pipes.SelectInsertMerger;
import net.intelie.pipes.SelectMerger;
import net.intelie.pipes.SelectState;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.UnsafeRow;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.modules.FallbackToNamed;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Iterables;

@Export(value={".select"})
@Help(omit=true)
public class SelectClauseImpl
implements SelectClause {
    private static final long serialVersionUID = 1L;
    private final NamedExpression[] items;
    private final Level level;
    private final int size;
    private final RowType type;

    public SelectClauseImpl(ArgQueue queue) throws PipeException {
        this((NamedExpression[])queue.arraySafe(NamedExpression.class, (Fallback)new FallbackToNamed()));
    }

    public SelectClauseImpl(NamedExpression ... items) throws PipeException {
        this.items = items;
        Level.ConstantLevel level = Level.CONSTANT;
        int size = 0;
        for (NamedExpression item : this.items) {
            item.validateExpansionOfRawTypes();
            level = Level.min((Level[])new Level[]{level, item.expr().level()});
            size += item.size();
        }
        this.level = level;
        this.size = size;
        this.type = this.makeType();
    }

    private RowType makeType() {
        ArrayList fields = new ArrayList();
        for (NamedExpression item : this.items) {
            fields.addAll(item.info());
        }
        return new RowType(new RowFields(new ClauseInfo(new FieldInfo[0]), new ClauseInfo(new FieldInfo[0]), new ClauseInfo(fields)));
    }

    public int size() {
        return this.size;
    }

    public Type<Row> type() {
        return this.type;
    }

    public Level level() {
        return Level.min((Level[])new Level[]{this.realLevel(), Level.SCALAR});
    }

    public Level realLevel() {
        return this.level;
    }

    public String toString() {
        return Iterables.join((String)", ", (Object[])this.items);
    }

    public long ttl() {
        long maxx = 1L;
        for (NamedExpression entry : this.items) {
            maxx = Math.max(maxx, entry.ttl());
        }
        return maxx;
    }

    public long weight() {
        long mem = 8 * this.items.length + 8;
        for (NamedExpression entry : this.items) {
            mem += entry.weight();
        }
        return mem;
    }

    public SelectState newState(int flips) {
        State[] states = new State[this.items.length];
        int i = 0;
        for (NamedExpression item : this.items) {
            states[i++] = item.newState(flips);
        }
        return new MyState(states);
    }

    public SelectMerger newMerger() {
        FullMerger[] mergers = new FullMerger[this.items.length];
        int i = 0;
        for (NamedExpression item : this.items) {
            mergers[i++] = item.newMerger();
        }
        return new MyMerger(mergers);
    }

    public SelectInsertMerger newInsertMerger() {
        InsertMerger[] mergers = new InsertMerger[this.items.length];
        int i = 0;
        for (NamedExpression item : this.items) {
            mergers[i++] = item.newInsertMerger();
        }
        return new MyInsertMerger(mergers);
    }

    public ArrayRow eval(Scope parent, Object obj) {
        UnsafeRow row = new UnsafeRow(this.size);
        this.evalUnsafe(parent, obj, row);
        return row.toRow();
    }

    public void validate(ValidationContext context) throws PipeException {
        for (NamedExpression item : this.items) {
            item.validate(context);
        }
    }

    public Iterable<?> explode() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (NamedExpression named : this.items) {
            if (named.autonamed() && !named.expand()) {
                list.add(named.expr());
                continue;
            }
            list.add(named);
        }
        return list;
    }

    public void evalUnsafe(Scope parent, Object obj, UnsafeRow row) {
        this.evalUnsafe(parent, obj, row, 0);
    }

    public void evalUnsafe(Scope parent, Object obj, UnsafeRow row, int index) {
        for (NamedExpression item : this.items) {
            index = item.evalUnsafe(parent, obj, row, index);
        }
    }

    public ClauseInfo info() {
        return this.type.fields().select();
    }

    public ArrayRow eval(Scope parent, Tree tree, WindowBounds bounds) {
        UnsafeRow row = new UnsafeRow(this.size);
        this.evalUnsafe(parent, tree, bounds, row);
        return row.toRow();
    }

    public void evalUnsafe(Scope parent, Tree tree, WindowBounds bounds, UnsafeRow row) {
        this.evalUnsafe(parent, tree, bounds, row, 0);
    }

    public void evalUnsafe(Scope parent, Tree tree, WindowBounds bounds, UnsafeRow row, int index) {
        Tree[] trees = ((MyTree)tree).trees;
        for (int i = 0; i < trees.length; ++i) {
            index = this.items[i].evalUnsafe(parent, trees[i], bounds, row, index);
        }
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        for (NamedExpression item : this.items) {
            item.visit(parent, visitor);
        }
        return visitor.newScope();
    }

    private class MyState
    implements SelectState {
        private final State[] states;

        public MyState(State[] states) {
            this.states = states;
        }

        public void yield(Scope parent, Object obj) {
            for (State state : this.states) {
                state.yield(parent, obj);
            }
        }

        public GroupingTree flip() {
            Tree[] trees = new Tree[this.states.length];
            for (int i = 0; i < trees.length; ++i) {
                trees[i] = this.states[i].flip();
            }
            return new MyTree(trees);
        }
    }

    private class MyInsertMerger
    extends InsertMerger.Base<MyTree>
    implements SelectInsertMerger {
        private final InsertMerger[] mergers;

        public MyInsertMerger(InsertMerger[] mergers) {
            this.mergers = mergers;
        }

        public void pushQ(MyTree tree) {
            InsertMerger.pushMany((InsertMerger[])this.mergers, (Tree[])tree.trees);
        }

        public void clear() {
            InsertMerger.clearMany((InsertMerger[])this.mergers);
        }

        public MyTree get() {
            return new MyTree(InsertMerger.getMany((InsertMerger[])this.mergers));
        }
    }

    private class MyMerger
    extends FullMerger.Base<MyTree>
    implements SelectMerger {
        private final FullMerger[] mergers;

        public MyMerger(FullMerger[] mergers) {
            this.mergers = mergers;
        }

        public void pushQ(MyTree tree) {
            InsertMerger.pushMany((FullMerger[])this.mergers, (Tree[])tree.trees);
        }

        public void pop() {
            FullMerger.popMany((FullMerger[])this.mergers);
        }

        public void clear() {
            InsertMerger.clearMany((FullMerger[])this.mergers);
        }

        public MyTree get() {
            return new MyTree(InsertMerger.getMany((FullMerger[])this.mergers));
        }
    }

    public static class MyTree
    implements GroupingTree {
        private static final long serialVersionUID = 1L;
        private final Tree[] trees;

        public MyTree(Tree[] trees) {
            this.trees = trees;
        }

        public Iterable<Map.Entry<Row, GroupingTree>> entries() {
            return Collections.singletonList(new AbstractMap.SimpleEntry<ArrayRow, MyTree>(new ArrayRow(new Object[0]), this));
        }

        public int size() {
            return 1;
        }

        public ArrayRowList toRowList(Scope parent, SelectClause select, WindowBounds bounds, ArrayRow first) {
            return new ArrayRowList(new Row[]{ArrayRow.concat((Row[])new Row[]{first, (Row)select.eval(parent, (Tree)this, bounds)})});
        }
    }
}

