/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.model;

import java.io.Serializable;
import java.util.Comparator;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.Evaluable;
import net.intelie.pipes.Export;
import net.intelie.pipes.Help;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.SortField;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.PipesComparator;

@Export(value={".sortfield"})
@Help(omit=true)
public class SortFieldImpl
implements SortField {
    private static final long serialVersionUID = 1L;
    private final Evaluable<? extends Comparable> expression;
    private final boolean reverse;

    public SortFieldImpl(ArgQueue queue) throws PipeException {
        this((Evaluable<? extends Comparable>)((Evaluable)queue.scalar((Type)Type.COMPARABLE).get()), (Boolean)queue.get(Boolean.class));
    }

    public SortFieldImpl(Evaluable<? extends Comparable> expression, boolean reverse) throws PipeException {
        this.expression = expression;
        this.reverse = reverse;
    }

    public Comparator<Object> makeComparator(Scope parent) {
        return (o1, o2) -> {
            int result = PipesComparator.instance().compare(this.expression.eval(parent, o1), this.expression.eval(parent, o2));
            return this.reverse ? -result : result;
        };
    }

    public Comparable eval(Scope parent, Object obj) {
        Comparable<ReverseComparable> answer = (Comparable<ReverseComparable>)this.expression.eval(parent, obj);
        return this.reverse ? new ReverseComparable(answer) : answer;
    }

    public void validate(ValidationContext context) throws PipeException {
        context.maybeDefer(this.expression);
    }

    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return this.expression.visit(parent, visitor);
    }

    public String toString() {
        return this.expression + (this.reverse ? " desc" : " asc");
    }

    public static class ReverseComparable
    implements Comparable<ReverseComparable>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Comparable answer;

        public ReverseComparable(Comparable answer) {
            this.answer = answer;
        }

        @Override
        public int compareTo(ReverseComparable o) {
            return -PipesComparator.instance().compare((Object)this.answer, (Object)o.answer);
        }
    }
}

